/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMObject {
    protected LLVMObject() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMObjectFileRef")
    public static long LLVMCreateObjectFile(@NativeType(value="LLVMMemoryBufferRef") long MemBuf) {
        long __functionAddress = Functions.CreateObjectFile;
        if (Checks.CHECKS) {
            Checks.check(MemBuf);
        }
        return JNI.invokePP(MemBuf, __functionAddress);
    }

    public static void LLVMDisposeObjectFile(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.DisposeObjectFile;
        if (Checks.CHECKS) {
            Checks.check(ObjectFile);
        }
        JNI.invokePV(ObjectFile, __functionAddress);
    }

    @NativeType(value="LLVMSectionIteratorRef")
    public static long LLVMGetSections(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.GetSections;
        if (Checks.CHECKS) {
            Checks.check(ObjectFile);
        }
        return JNI.invokePP(ObjectFile, __functionAddress);
    }

    public static void LLVMDisposeSectionIterator(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.DisposeSectionIterator;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        JNI.invokePV(SI, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsSectionIteratorAtEnd(@NativeType(value="LLVMObjectFileRef") long ObjectFile, @NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.IsSectionIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check(ObjectFile);
            Checks.check(SI);
        }
        return JNI.invokePPI(ObjectFile, SI, __functionAddress) != 0;
    }

    public static void LLVMMoveToNextSection(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.MoveToNextSection;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        JNI.invokePV(SI, __functionAddress);
    }

    public static void LLVMMoveToContainingSection(@NativeType(value="LLVMSectionIteratorRef") long Sect, @NativeType(value="LLVMSymbolIteratorRef") long Sym) {
        long __functionAddress = Functions.MoveToContainingSection;
        if (Checks.CHECKS) {
            Checks.check(Sect);
            Checks.check(Sym);
        }
        JNI.invokePPV(Sect, Sym, __functionAddress);
    }

    @NativeType(value="LLVMSymbolIteratorRef")
    public static long LLVMGetSymbols(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.GetSymbols;
        if (Checks.CHECKS) {
            Checks.check(ObjectFile);
        }
        return JNI.invokePP(ObjectFile, __functionAddress);
    }

    public static void LLVMDisposeSymbolIterator(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.DisposeSymbolIterator;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        JNI.invokePV(SI, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsSymbolIteratorAtEnd(@NativeType(value="LLVMObjectFileRef") long ObjectFile, @NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.IsSymbolIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check(ObjectFile);
            Checks.check(SI);
        }
        return JNI.invokePPI(ObjectFile, SI, __functionAddress) != 0;
    }

    public static void LLVMMoveToNextSymbol(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.MoveToNextSymbol;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        JNI.invokePV(SI, __functionAddress);
    }

    public static long nLLVMGetSectionName(long SI) {
        long __functionAddress = Functions.GetSectionName;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        return JNI.invokePP(SI, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetSectionName(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSectionName(SI);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSectionSize(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.GetSectionSize;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        return JNI.invokePJ(SI, __functionAddress);
    }

    public static long nLLVMGetSectionContents(long SI) {
        long __functionAddress = Functions.GetSectionContents;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        return JNI.invokePP(SI, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetSectionContents(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSectionContents(SI);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSectionAddress(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.GetSectionAddress;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        return JNI.invokePJ(SI, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetSectionContainsSymbol(@NativeType(value="LLVMSectionIteratorRef") long SI, @NativeType(value="LLVMSymbolIteratorRef") long Sym) {
        long __functionAddress = Functions.GetSectionContainsSymbol;
        if (Checks.CHECKS) {
            Checks.check(SI);
            Checks.check(Sym);
        }
        return JNI.invokePPI(SI, Sym, __functionAddress) != 0;
    }

    @NativeType(value="LLVMRelocationIteratorRef")
    public static long LLVMGetRelocations(@NativeType(value="LLVMSectionIteratorRef") long Section) {
        long __functionAddress = Functions.GetRelocations;
        if (Checks.CHECKS) {
            Checks.check(Section);
        }
        return JNI.invokePP(Section, __functionAddress);
    }

    public static void LLVMDisposeRelocationIterator(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.DisposeRelocationIterator;
        if (Checks.CHECKS) {
            Checks.check(RI);
        }
        JNI.invokePV(RI, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsRelocationIteratorAtEnd(@NativeType(value="LLVMSectionIteratorRef") long Section, @NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.IsRelocationIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check(Section);
            Checks.check(RI);
        }
        return JNI.invokePPI(Section, RI, __functionAddress) != 0;
    }

    public static void LLVMMoveToNextRelocation(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.MoveToNextRelocation;
        if (Checks.CHECKS) {
            Checks.check(RI);
        }
        JNI.invokePV(RI, __functionAddress);
    }

    public static long nLLVMGetSymbolName(long SI) {
        long __functionAddress = Functions.GetSymbolName;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        return JNI.invokePP(SI, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetSymbolName(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSymbolName(SI);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSymbolAddress(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.GetSymbolAddress;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        return JNI.invokePJ(SI, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSymbolSize(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.GetSymbolSize;
        if (Checks.CHECKS) {
            Checks.check(SI);
        }
        return JNI.invokePJ(SI, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetRelocationOffset(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationOffset;
        if (Checks.CHECKS) {
            Checks.check(RI);
        }
        return JNI.invokePJ(RI, __functionAddress);
    }

    @NativeType(value="LLVMSymbolIteratorRef")
    public static long LLVMGetRelocationSymbol(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationSymbol;
        if (Checks.CHECKS) {
            Checks.check(RI);
        }
        return JNI.invokePP(RI, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetRelocationType(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationType;
        if (Checks.CHECKS) {
            Checks.check(RI);
        }
        return JNI.invokePJ(RI, __functionAddress);
    }

    public static long nLLVMGetRelocationTypeName(long RI) {
        long __functionAddress = Functions.GetRelocationTypeName;
        if (Checks.CHECKS) {
            Checks.check(RI);
        }
        return JNI.invokePP(RI, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetRelocationTypeName(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __result = LLVMObject.nLLVMGetRelocationTypeName(RI);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static long nLLVMGetRelocationValueString(long RI) {
        long __functionAddress = Functions.GetRelocationValueString;
        if (Checks.CHECKS) {
            Checks.check(RI);
        }
        return JNI.invokePP(RI, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetRelocationValueString(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __result = LLVMObject.nLLVMGetRelocationValueString(RI);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static final class Functions {
        public static final long CreateObjectFile = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateObjectFile");
        public static final long DisposeObjectFile = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeObjectFile");
        public static final long GetSections = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSections");
        public static final long DisposeSectionIterator = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeSectionIterator");
        public static final long IsSectionIteratorAtEnd = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMIsSectionIteratorAtEnd");
        public static final long MoveToNextSection = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMMoveToNextSection");
        public static final long MoveToContainingSection = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMMoveToContainingSection");
        public static final long GetSymbols = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSymbols");
        public static final long DisposeSymbolIterator = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeSymbolIterator");
        public static final long IsSymbolIteratorAtEnd = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMIsSymbolIteratorAtEnd");
        public static final long MoveToNextSymbol = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMMoveToNextSymbol");
        public static final long GetSectionName = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSectionName");
        public static final long GetSectionSize = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSectionSize");
        public static final long GetSectionContents = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSectionContents");
        public static final long GetSectionAddress = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSectionAddress");
        public static final long GetSectionContainsSymbol = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSectionContainsSymbol");
        public static final long GetRelocations = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetRelocations");
        public static final long DisposeRelocationIterator = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeRelocationIterator");
        public static final long IsRelocationIteratorAtEnd = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMIsRelocationIteratorAtEnd");
        public static final long MoveToNextRelocation = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMMoveToNextRelocation");
        public static final long GetSymbolName = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSymbolName");
        public static final long GetSymbolAddress = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSymbolAddress");
        public static final long GetSymbolSize = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSymbolSize");
        public static final long GetRelocationOffset = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetRelocationOffset");
        public static final long GetRelocationSymbol = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetRelocationSymbol");
        public static final long GetRelocationType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetRelocationType");
        public static final long GetRelocationTypeName = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetRelocationTypeName");
        public static final long GetRelocationValueString = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetRelocationValueString");

        private Functions() {
        }
    }
}

