/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCLookupSetElement
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int LOOKUPFLAGS;

    public LLVMOrcCLookupSetElement(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCLookupSetElement.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMOrcCLookupSetElement.nName(this.address());
    }

    @NativeType(value="LLVMOrcSymbolLookupFlags")
    public int LookupFlags() {
        return LLVMOrcCLookupSetElement.nLookupFlags(this.address());
    }

    public LLVMOrcCLookupSetElement Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMOrcCLookupSetElement.nName(this.address(), value);
        return this;
    }

    public LLVMOrcCLookupSetElement LookupFlags(@NativeType(value="LLVMOrcSymbolLookupFlags") int value) {
        LLVMOrcCLookupSetElement.nLookupFlags(this.address(), value);
        return this;
    }

    public LLVMOrcCLookupSetElement set(long Name2, int LookupFlags) {
        this.Name(Name2);
        this.LookupFlags(LookupFlags);
        return this;
    }

    public LLVMOrcCLookupSetElement set(LLVMOrcCLookupSetElement src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCLookupSetElement malloc() {
        return LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LLVMOrcCLookupSetElement calloc() {
        return LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LLVMOrcCLookupSetElement create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCLookupSetElement create(long address) {
        return LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, address);
    }

    @Nullable
    public static LLVMOrcCLookupSetElement createSafe(long address) {
        return address == 0L ? null : LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LLVMOrcCLookupSetElement.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LLVMOrcCLookupSetElement.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LLVMOrcCLookupSetElement.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCLookupSetElement.__create(capacity, SIZEOF);
        return LLVMOrcCLookupSetElement.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LLVMOrcCLookupSetElement.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LLVMOrcCLookupSetElement.wrap(Buffer.class, address, capacity);
    }

    public static LLVMOrcCLookupSetElement malloc(MemoryStack stack) {
        return LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMOrcCLookupSetElement calloc(MemoryStack stack) {
        return LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LLVMOrcCLookupSetElement.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LLVMOrcCLookupSetElement.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NAME);
    }

    public static int nLookupFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOOKUPFLAGS);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NAME, Checks.check(value));
    }

    public static void nLookupFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOOKUPFLAGS, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = LLVMOrcCLookupSetElement.__struct(LLVMOrcCLookupSetElement.__member(POINTER_SIZE), LLVMOrcCLookupSetElement.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        LOOKUPFLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCLookupSetElement, Buffer>
    implements NativeResource {
        private static final LLVMOrcCLookupSetElement ELEMENT_FACTORY = LLVMOrcCLookupSetElement.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LLVMOrcCLookupSetElement getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMOrcCLookupSetElement.nName(this.address());
        }

        @NativeType(value="LLVMOrcSymbolLookupFlags")
        public int LookupFlags() {
            return LLVMOrcCLookupSetElement.nLookupFlags(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMOrcCLookupSetElement.nName(this.address(), value);
            return this;
        }

        public Buffer LookupFlags(@NativeType(value="LLVMOrcSymbolLookupFlags") int value) {
            LLVMOrcCLookupSetElement.nLookupFlags(this.address(), value);
            return this;
        }
    }
}

