/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMJITSymbolFlags;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolAliasMapEntry
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int FLAGS;

    public LLVMOrcCSymbolAliasMapEntry(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCSymbolAliasMapEntry.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMOrcCSymbolAliasMapEntry.nName(this.address());
    }

    public LLVMJITSymbolFlags Flags() {
        return LLVMOrcCSymbolAliasMapEntry.nFlags(this.address());
    }

    public LLVMOrcCSymbolAliasMapEntry Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMOrcCSymbolAliasMapEntry.nName(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolAliasMapEntry Flags(LLVMJITSymbolFlags value) {
        LLVMOrcCSymbolAliasMapEntry.nFlags(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolAliasMapEntry Flags(Consumer<LLVMJITSymbolFlags> consumer) {
        consumer.accept(this.Flags());
        return this;
    }

    public LLVMOrcCSymbolAliasMapEntry set(long Name2, LLVMJITSymbolFlags Flags) {
        this.Name(Name2);
        this.Flags(Flags);
        return this;
    }

    public LLVMOrcCSymbolAliasMapEntry set(LLVMOrcCSymbolAliasMapEntry src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolAliasMapEntry malloc() {
        return LLVMOrcCSymbolAliasMapEntry.wrap(LLVMOrcCSymbolAliasMapEntry.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LLVMOrcCSymbolAliasMapEntry calloc() {
        return LLVMOrcCSymbolAliasMapEntry.wrap(LLVMOrcCSymbolAliasMapEntry.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LLVMOrcCSymbolAliasMapEntry create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LLVMOrcCSymbolAliasMapEntry.wrap(LLVMOrcCSymbolAliasMapEntry.class, MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCSymbolAliasMapEntry create(long address) {
        return LLVMOrcCSymbolAliasMapEntry.wrap(LLVMOrcCSymbolAliasMapEntry.class, address);
    }

    @Nullable
    public static LLVMOrcCSymbolAliasMapEntry createSafe(long address) {
        return address == 0L ? null : LLVMOrcCSymbolAliasMapEntry.wrap(LLVMOrcCSymbolAliasMapEntry.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LLVMOrcCSymbolAliasMapEntry.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LLVMOrcCSymbolAliasMapEntry.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LLVMOrcCSymbolAliasMapEntry.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolAliasMapEntry.__create(capacity, SIZEOF);
        return LLVMOrcCSymbolAliasMapEntry.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LLVMOrcCSymbolAliasMapEntry.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LLVMOrcCSymbolAliasMapEntry.wrap(Buffer.class, address, capacity);
    }

    public static LLVMOrcCSymbolAliasMapEntry malloc(MemoryStack stack) {
        return LLVMOrcCSymbolAliasMapEntry.wrap(LLVMOrcCSymbolAliasMapEntry.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMOrcCSymbolAliasMapEntry calloc(MemoryStack stack) {
        return LLVMOrcCSymbolAliasMapEntry.wrap(LLVMOrcCSymbolAliasMapEntry.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LLVMOrcCSymbolAliasMapEntry.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LLVMOrcCSymbolAliasMapEntry.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NAME);
    }

    public static LLVMJITSymbolFlags nFlags(long struct) {
        return LLVMJITSymbolFlags.create(struct + (long)FLAGS);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NAME, Checks.check(value));
    }

    public static void nFlags(long struct, LLVMJITSymbolFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, LLVMJITSymbolFlags.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolAliasMapEntry.__struct(LLVMOrcCSymbolAliasMapEntry.__member(POINTER_SIZE), LLVMOrcCSymbolAliasMapEntry.__member(LLVMJITSymbolFlags.SIZEOF, LLVMJITSymbolFlags.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolAliasMapEntry, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolAliasMapEntry ELEMENT_FACTORY = LLVMOrcCSymbolAliasMapEntry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LLVMOrcCSymbolAliasMapEntry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMOrcCSymbolAliasMapEntry.nName(this.address());
        }

        public LLVMJITSymbolFlags Flags() {
            return LLVMOrcCSymbolAliasMapEntry.nFlags(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMOrcCSymbolAliasMapEntry.nName(this.address(), value);
            return this;
        }

        public Buffer Flags(LLVMJITSymbolFlags value) {
            LLVMOrcCSymbolAliasMapEntry.nFlags(this.address(), value);
            return this;
        }

        public Buffer Flags(Consumer<LLVMJITSymbolFlags> consumer) {
            consumer.accept(this.Flags());
            return this;
        }
    }
}

