/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMOrcCSymbolAliasMapEntry;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolAliasMapPair
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int ENTRY;

    public LLVMOrcCSymbolAliasMapPair(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCSymbolAliasMapPair.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMOrcCSymbolAliasMapPair.nName(this.address());
    }

    public LLVMOrcCSymbolAliasMapEntry Entry() {
        return LLVMOrcCSymbolAliasMapPair.nEntry(this.address());
    }

    public LLVMOrcCSymbolAliasMapPair Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMOrcCSymbolAliasMapPair.nName(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolAliasMapPair Entry(LLVMOrcCSymbolAliasMapEntry value) {
        LLVMOrcCSymbolAliasMapPair.nEntry(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolAliasMapPair Entry(Consumer<LLVMOrcCSymbolAliasMapEntry> consumer) {
        consumer.accept(this.Entry());
        return this;
    }

    public LLVMOrcCSymbolAliasMapPair set(long Name2, LLVMOrcCSymbolAliasMapEntry Entry2) {
        this.Name(Name2);
        this.Entry(Entry2);
        return this;
    }

    public LLVMOrcCSymbolAliasMapPair set(LLVMOrcCSymbolAliasMapPair src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolAliasMapPair malloc() {
        return LLVMOrcCSymbolAliasMapPair.wrap(LLVMOrcCSymbolAliasMapPair.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LLVMOrcCSymbolAliasMapPair calloc() {
        return LLVMOrcCSymbolAliasMapPair.wrap(LLVMOrcCSymbolAliasMapPair.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LLVMOrcCSymbolAliasMapPair create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LLVMOrcCSymbolAliasMapPair.wrap(LLVMOrcCSymbolAliasMapPair.class, MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCSymbolAliasMapPair create(long address) {
        return LLVMOrcCSymbolAliasMapPair.wrap(LLVMOrcCSymbolAliasMapPair.class, address);
    }

    @Nullable
    public static LLVMOrcCSymbolAliasMapPair createSafe(long address) {
        return address == 0L ? null : LLVMOrcCSymbolAliasMapPair.wrap(LLVMOrcCSymbolAliasMapPair.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LLVMOrcCSymbolAliasMapPair.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LLVMOrcCSymbolAliasMapPair.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LLVMOrcCSymbolAliasMapPair.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolAliasMapPair.__create(capacity, SIZEOF);
        return LLVMOrcCSymbolAliasMapPair.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LLVMOrcCSymbolAliasMapPair.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LLVMOrcCSymbolAliasMapPair.wrap(Buffer.class, address, capacity);
    }

    public static LLVMOrcCSymbolAliasMapPair malloc(MemoryStack stack) {
        return LLVMOrcCSymbolAliasMapPair.wrap(LLVMOrcCSymbolAliasMapPair.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMOrcCSymbolAliasMapPair calloc(MemoryStack stack) {
        return LLVMOrcCSymbolAliasMapPair.wrap(LLVMOrcCSymbolAliasMapPair.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LLVMOrcCSymbolAliasMapPair.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LLVMOrcCSymbolAliasMapPair.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NAME);
    }

    public static LLVMOrcCSymbolAliasMapEntry nEntry(long struct) {
        return LLVMOrcCSymbolAliasMapEntry.create(struct + (long)ENTRY);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NAME, Checks.check(value));
    }

    public static void nEntry(long struct, LLVMOrcCSymbolAliasMapEntry value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ENTRY, LLVMOrcCSymbolAliasMapEntry.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
        LLVMOrcCSymbolAliasMapEntry.validate(struct + (long)ENTRY);
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolAliasMapPair.__struct(LLVMOrcCSymbolAliasMapPair.__member(POINTER_SIZE), LLVMOrcCSymbolAliasMapPair.__member(LLVMOrcCSymbolAliasMapEntry.SIZEOF, LLVMOrcCSymbolAliasMapEntry.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        ENTRY = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolAliasMapPair, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolAliasMapPair ELEMENT_FACTORY = LLVMOrcCSymbolAliasMapPair.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LLVMOrcCSymbolAliasMapPair getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMOrcCSymbolAliasMapPair.nName(this.address());
        }

        public LLVMOrcCSymbolAliasMapEntry Entry() {
            return LLVMOrcCSymbolAliasMapPair.nEntry(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMOrcCSymbolAliasMapPair.nName(this.address(), value);
            return this;
        }

        public Buffer Entry(LLVMOrcCSymbolAliasMapEntry value) {
            LLVMOrcCSymbolAliasMapPair.nEntry(this.address(), value);
            return this;
        }

        public Buffer Entry(Consumer<LLVMOrcCSymbolAliasMapEntry> consumer) {
            consumer.accept(this.Entry());
            return this;
        }
    }
}

