/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolsList
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SYMBOLS;
    public static final int LENGTH;

    public LLVMOrcCSymbolsList(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCSymbolsList.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef *")
    public PointerBuffer Symbols() {
        return LLVMOrcCSymbolsList.nSymbols(this.address());
    }

    @NativeType(value="size_t")
    public long Length() {
        return LLVMOrcCSymbolsList.nLength(this.address());
    }

    public LLVMOrcCSymbolsList Symbols(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef *") PointerBuffer value) {
        LLVMOrcCSymbolsList.nSymbols(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolsList set(LLVMOrcCSymbolsList src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolsList malloc() {
        return LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LLVMOrcCSymbolsList calloc() {
        return LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LLVMOrcCSymbolsList create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCSymbolsList create(long address) {
        return LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, address);
    }

    @Nullable
    public static LLVMOrcCSymbolsList createSafe(long address) {
        return address == 0L ? null : LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LLVMOrcCSymbolsList.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LLVMOrcCSymbolsList.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LLVMOrcCSymbolsList.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolsList.__create(capacity, SIZEOF);
        return LLVMOrcCSymbolsList.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LLVMOrcCSymbolsList.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LLVMOrcCSymbolsList.wrap(Buffer.class, address, capacity);
    }

    public static LLVMOrcCSymbolsList malloc(MemoryStack stack) {
        return LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMOrcCSymbolsList calloc(MemoryStack stack) {
        return LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LLVMOrcCSymbolsList.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LLVMOrcCSymbolsList.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nSymbols(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)SYMBOLS), (int)LLVMOrcCSymbolsList.nLength(struct));
    }

    public static long nLength(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LENGTH);
    }

    public static void nSymbols(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SYMBOLS, MemoryUtil.memAddress(value));
        LLVMOrcCSymbolsList.nLength(struct, value.remaining());
    }

    public static void nLength(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)LENGTH, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SYMBOLS));
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolsList.__struct(LLVMOrcCSymbolsList.__member(POINTER_SIZE), LLVMOrcCSymbolsList.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SYMBOLS = layout.offsetof(0);
        LENGTH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolsList, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolsList ELEMENT_FACTORY = LLVMOrcCSymbolsList.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LLVMOrcCSymbolsList getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef *")
        public PointerBuffer Symbols() {
            return LLVMOrcCSymbolsList.nSymbols(this.address());
        }

        @NativeType(value="size_t")
        public long Length() {
            return LLVMOrcCSymbolsList.nLength(this.address());
        }

        public Buffer Symbols(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef *") PointerBuffer value) {
            LLVMOrcCSymbolsList.nSymbols(this.address(), value);
            return this;
        }
    }
}

