/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMSupport {
    protected LLVMSupport() {
        throw new UnsupportedOperationException();
    }

    public static int nLLVMLoadLibraryPermanently(long Filename) {
        long __functionAddress = Functions.LoadLibraryPermanently;
        return JNI.invokePI(Filename, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMLoadLibraryPermanently(@NativeType(value="char const *") ByteBuffer Filename) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Filename);
        }
        return LLVMSupport.nLLVMLoadLibraryPermanently(MemoryUtil.memAddress(Filename)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBool")
    public static boolean LLVMLoadLibraryPermanently(@NativeType(value="char const *") CharSequence Filename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Filename, true);
            long FilenameEncoded = stack.getPointerAddress();
            boolean bl = LLVMSupport.nLLVMLoadLibraryPermanently(FilenameEncoded) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMParseCommandLineOptions(int argc, long argv, long Overview) {
        long __functionAddress = Functions.ParseCommandLineOptions;
        JNI.invokePPV(argc, argv, Overview, __functionAddress);
    }

    public static void LLVMParseCommandLineOptions(@NativeType(value="char const * const *") PointerBuffer argv, @NativeType(value="char const *") ByteBuffer Overview) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Overview);
        }
        LLVMSupport.nLLVMParseCommandLineOptions(argv.remaining(), MemoryUtil.memAddress(argv), MemoryUtil.memAddress(Overview));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMParseCommandLineOptions(@NativeType(value="char const * const *") PointerBuffer argv, @NativeType(value="char const *") CharSequence Overview) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Overview, true);
            long OverviewEncoded = stack.getPointerAddress();
            LLVMSupport.nLLVMParseCommandLineOptions(argv.remaining(), MemoryUtil.memAddress(argv), OverviewEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMSearchForAddressOfSymbol(long symbolName) {
        long __functionAddress = Functions.SearchForAddressOfSymbol;
        return JNI.invokePP(symbolName, __functionAddress);
    }

    @NativeType(value="void *")
    public static long LLVMSearchForAddressOfSymbol(@NativeType(value="char const *") ByteBuffer symbolName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(symbolName);
        }
        return LLVMSupport.nLLVMSearchForAddressOfSymbol(MemoryUtil.memAddress(symbolName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long LLVMSearchForAddressOfSymbol(@NativeType(value="char const *") CharSequence symbolName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(symbolName, true);
            long symbolNameEncoded = stack.getPointerAddress();
            long l = LLVMSupport.nLLVMSearchForAddressOfSymbol(symbolNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMAddSymbol(long symbolName, long symbolValue) {
        long __functionAddress = Functions.AddSymbol;
        if (Checks.CHECKS) {
            Checks.check(symbolValue);
        }
        JNI.invokePPV(symbolName, symbolValue, __functionAddress);
    }

    public static void LLVMAddSymbol(@NativeType(value="char const *") ByteBuffer symbolName, @NativeType(value="void *") long symbolValue) {
        if (Checks.CHECKS) {
            Checks.checkNT1(symbolName);
        }
        LLVMSupport.nLLVMAddSymbol(MemoryUtil.memAddress(symbolName), symbolValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMAddSymbol(@NativeType(value="char const *") CharSequence symbolName, @NativeType(value="void *") long symbolValue) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(symbolName, true);
            long symbolNameEncoded = stack.getPointerAddress();
            LLVMSupport.nLLVMAddSymbol(symbolNameEncoded, symbolValue);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static final class Functions {
        public static final long LoadLibraryPermanently = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMLoadLibraryPermanently");
        public static final long ParseCommandLineOptions = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMParseCommandLineOptions");
        public static final long SearchForAddressOfSymbol = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMSearchForAddressOfSymbol");
        public static final long AddSymbol = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddSymbol");

        private Functions() {
        }
    }
}

