/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMTarget {
    public static final int LLVMBigEndian = 0;
    public static final int LLVMLittleEndian = 1;

    protected LLVMTarget() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMTargetDataRef")
    public static long LLVMGetModuleDataLayout(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetModuleDataLayout;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    public static void LLVMSetModuleDataLayout(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTargetDataRef") long DL) {
        long __functionAddress = Functions.SetModuleDataLayout;
        if (Checks.CHECKS) {
            Checks.check(M);
            Checks.check(DL);
        }
        JNI.invokePPV(M, DL, __functionAddress);
    }

    public static long nLLVMCreateTargetData(long StringRep) {
        long __functionAddress = Functions.CreateTargetData;
        return JNI.invokePP(StringRep, __functionAddress);
    }

    @NativeType(value="LLVMTargetDataRef")
    public static long LLVMCreateTargetData(@NativeType(value="char const *") ByteBuffer StringRep) {
        if (Checks.CHECKS) {
            Checks.checkNT1(StringRep);
        }
        return LLVMTarget.nLLVMCreateTargetData(MemoryUtil.memAddress(StringRep));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTargetDataRef")
    public static long LLVMCreateTargetData(@NativeType(value="char const *") CharSequence StringRep) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(StringRep, true);
            long StringRepEncoded = stack.getPointerAddress();
            long l = LLVMTarget.nLLVMCreateTargetData(StringRepEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDisposeTargetData(@NativeType(value="LLVMTargetDataRef") long TD) {
        long __functionAddress = Functions.DisposeTargetData;
        if (Checks.CHECKS) {
            Checks.check(TD);
        }
        JNI.invokePV(TD, __functionAddress);
    }

    public static void LLVMAddTargetLibraryInfo(@NativeType(value="LLVMTargetLibraryInfoRef") long TLI, @NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddTargetLibraryInfo;
        if (Checks.CHECKS) {
            Checks.check(TLI);
            Checks.check(PM);
        }
        JNI.invokePPV(TLI, PM, __functionAddress);
    }

    public static long nLLVMCopyStringRepOfTargetData(long TD) {
        long __functionAddress = Functions.CopyStringRepOfTargetData;
        if (Checks.CHECKS) {
            Checks.check(TD);
        }
        return JNI.invokePP(TD, __functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMCopyStringRepOfTargetData(@NativeType(value="LLVMTargetDataRef") long TD) {
        long __result = LLVMTarget.nLLVMCopyStringRepOfTargetData(TD);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="enum LLVMByteOrdering")
    public static int LLVMByteOrder(@NativeType(value="LLVMTargetDataRef") long TD) {
        long __functionAddress = Functions.ByteOrder;
        if (Checks.CHECKS) {
            Checks.check(TD);
        }
        return JNI.invokePI(TD, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMPointerSize(@NativeType(value="LLVMTargetDataRef") long TD) {
        long __functionAddress = Functions.PointerSize;
        if (Checks.CHECKS) {
            Checks.check(TD);
        }
        return JNI.invokePI(TD, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMPointerSizeForAS(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="unsigned int") int AS) {
        long __functionAddress = Functions.PointerSizeForAS;
        if (Checks.CHECKS) {
            Checks.check(TD);
        }
        return JNI.invokePI(TD, AS, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntPtrType(@NativeType(value="LLVMTargetDataRef") long TD) {
        long __functionAddress = Functions.IntPtrType;
        if (Checks.CHECKS) {
            Checks.check(TD);
        }
        return JNI.invokePP(TD, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntPtrTypeForAS(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="unsigned int") int AS) {
        long __functionAddress = Functions.IntPtrTypeForAS;
        if (Checks.CHECKS) {
            Checks.check(TD);
        }
        return JNI.invokePP(TD, AS, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntPtrTypeInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMTargetDataRef") long TD) {
        long __functionAddress = Functions.IntPtrTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
            Checks.check(TD);
        }
        return JNI.invokePPP(C, TD, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntPtrTypeForASInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="unsigned int") int AS) {
        long __functionAddress = Functions.IntPtrTypeForASInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
            Checks.check(TD);
        }
        return JNI.invokePPP(C, TD, AS, __functionAddress);
    }

    @NativeType(value="unsigned long long")
    public static long LLVMSizeOfTypeInBits(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.SizeOfTypeInBits;
        if (Checks.CHECKS) {
            Checks.check(TD);
            Checks.check(Ty);
        }
        return JNI.invokePPJ(TD, Ty, __functionAddress);
    }

    @NativeType(value="unsigned long long")
    public static long LLVMStoreSizeOfType(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.StoreSizeOfType;
        if (Checks.CHECKS) {
            Checks.check(TD);
            Checks.check(Ty);
        }
        return JNI.invokePPJ(TD, Ty, __functionAddress);
    }

    @NativeType(value="unsigned long long")
    public static long LLVMABISizeOfType(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.ABISizeOfType;
        if (Checks.CHECKS) {
            Checks.check(TD);
            Checks.check(Ty);
        }
        return JNI.invokePPJ(TD, Ty, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMABIAlignmentOfType(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.ABIAlignmentOfType;
        if (Checks.CHECKS) {
            Checks.check(TD);
            Checks.check(Ty);
        }
        return JNI.invokePPI(TD, Ty, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMCallFrameAlignmentOfType(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.CallFrameAlignmentOfType;
        if (Checks.CHECKS) {
            Checks.check(TD);
            Checks.check(Ty);
        }
        return JNI.invokePPI(TD, Ty, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMPreferredAlignmentOfType(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.PreferredAlignmentOfType;
        if (Checks.CHECKS) {
            Checks.check(TD);
            Checks.check(Ty);
        }
        return JNI.invokePPI(TD, Ty, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMPreferredAlignmentOfGlobal(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.PreferredAlignmentOfGlobal;
        if (Checks.CHECKS) {
            Checks.check(TD);
            Checks.check(GlobalVar);
        }
        return JNI.invokePPI(TD, GlobalVar, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMElementAtOffset(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="unsigned long long") long Offset) {
        long __functionAddress = Functions.ElementAtOffset;
        if (Checks.CHECKS) {
            Checks.check(TD);
            Checks.check(StructTy);
        }
        return JNI.invokePPJI(TD, StructTy, Offset, __functionAddress);
    }

    @NativeType(value="unsigned long long")
    public static long LLVMOffsetOfElement(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="unsigned int") int Element) {
        long __functionAddress = Functions.OffsetOfElement;
        if (Checks.CHECKS) {
            Checks.check(TD);
            Checks.check(StructTy);
        }
        return JNI.invokePPJ(TD, StructTy, Element, __functionAddress);
    }

    public static final class Functions {
        public static final long GetModuleDataLayout = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetModuleDataLayout");
        public static final long SetModuleDataLayout = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMSetModuleDataLayout");
        public static final long CreateTargetData = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateTargetData");
        public static final long DisposeTargetData = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeTargetData");
        public static final long AddTargetLibraryInfo = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddTargetLibraryInfo");
        public static final long CopyStringRepOfTargetData = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCopyStringRepOfTargetData");
        public static final long ByteOrder = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMByteOrder");
        public static final long PointerSize = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPointerSize");
        public static final long PointerSizeForAS = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPointerSizeForAS");
        public static final long IntPtrType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMIntPtrType");
        public static final long IntPtrTypeForAS = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMIntPtrTypeForAS");
        public static final long IntPtrTypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMIntPtrTypeInContext");
        public static final long IntPtrTypeForASInContext = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMIntPtrTypeForASInContext");
        public static final long SizeOfTypeInBits = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMSizeOfTypeInBits");
        public static final long StoreSizeOfType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMStoreSizeOfType");
        public static final long ABISizeOfType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMABISizeOfType");
        public static final long ABIAlignmentOfType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMABIAlignmentOfType");
        public static final long CallFrameAlignmentOfType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCallFrameAlignmentOfType");
        public static final long PreferredAlignmentOfType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPreferredAlignmentOfType");
        public static final long PreferredAlignmentOfGlobal = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPreferredAlignmentOfGlobal");
        public static final long ElementAtOffset = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMElementAtOffset");
        public static final long OffsetOfElement = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOffsetOfElement");

        private Functions() {
        }
    }
}

