/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMMustPreserveI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMTransforms {
    protected LLVMTransforms() {
        throw new UnsupportedOperationException();
    }

    public static void LLVMAddAggressiveInstCombinerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAggressiveInstCombinerPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCoroEarlyPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroEarlyPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCoroSplitPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroSplitPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCoroElidePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroElidePass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCoroCleanupPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroCleanupPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMPassManagerBuilderAddCoroutinePassesToExtensionPoints(@NativeType(value="LLVMPassManagerBuilderRef") long PMB) {
        long __functionAddress = Functions.PassManagerBuilderAddCoroutinePassesToExtensionPoints;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, __functionAddress);
    }

    public static void LLVMAddInstructionCombiningPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddInstructionCombiningPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddInstructionSimplifyPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddInstructionSimplifyPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddArgumentPromotionPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddArgumentPromotionPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddConstantMergePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddConstantMergePass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddMergeFunctionsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddMergeFunctionsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCalledValuePropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCalledValuePropagationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddDeadArgEliminationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDeadArgEliminationPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddFunctionAttrsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddFunctionAttrsPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddFunctionInliningPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddFunctionInliningPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddAlwaysInlinerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAlwaysInlinerPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddGlobalDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddGlobalDCEPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddGlobalOptimizerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddGlobalOptimizerPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddIPConstantPropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddIPConstantPropagationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddPruneEHPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddPruneEHPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddIPSCCPPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddIPSCCPPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddInternalizePass(@NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="unsigned int") int AllButMain) {
        long __functionAddress = Functions.AddInternalizePass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, AllButMain, __functionAddress);
    }

    public static void nLLVMAddInternalizePassWithMustPreservePredicate(long PM, long Context, long MustPreserve) {
        long __functionAddress = Functions.AddInternalizePassWithMustPreservePredicate;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
            Checks.check(Context);
        }
        JNI.invokePPPV(PM, Context, MustPreserve, __functionAddress);
    }

    public static void LLVMAddInternalizePassWithMustPreservePredicate(@NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="void *") long Context, @NativeType(value="LLVMBool (*) (LLVMValueRef, void *)") LLVMMustPreserveI MustPreserve) {
        LLVMTransforms.nLLVMAddInternalizePassWithMustPreservePredicate(PM, Context, MustPreserve.address());
    }

    public static void LLVMAddStripDeadPrototypesPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddStripDeadPrototypesPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddStripSymbolsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddStripSymbolsPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static long nLLVMRunPasses(long M, long Passes, long TM, long Options2) {
        long __functionAddress = Functions.RunPasses;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
            Checks.check(TM);
            Checks.check(Options2);
        }
        return JNI.invokePPPPP(M, Passes, TM, Options2, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMRunPasses(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Passes, @NativeType(value="LLVMTargetMachineRef") long TM, @NativeType(value="LLVMPassBuilderOptionsRef") long Options2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Passes);
        }
        return LLVMTransforms.nLLVMRunPasses(M, MemoryUtil.memAddress(Passes), TM, Options2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMRunPasses(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Passes, @NativeType(value="LLVMTargetMachineRef") long TM, @NativeType(value="LLVMPassBuilderOptionsRef") long Options2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Passes, true);
            long PassesEncoded = stack.getPointerAddress();
            long l = LLVMTransforms.nLLVMRunPasses(M, PassesEncoded, TM, Options2);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMPassBuilderOptionsRef")
    public static long LLVMCreatePassBuilderOptions() {
        long __functionAddress = Functions.CreatePassBuilderOptions;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetVerifyEach(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="LLVMBool") boolean VerifyEach) {
        long __functionAddress = Functions.PassBuilderOptionsSetVerifyEach;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, VerifyEach ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetDebugLogging(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="LLVMBool") boolean DebugLogging) {
        long __functionAddress = Functions.PassBuilderOptionsSetDebugLogging;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, DebugLogging ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLoopInterleaving(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="LLVMBool") boolean LoopInterleaving) {
        long __functionAddress = Functions.PassBuilderOptionsSetLoopInterleaving;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, LoopInterleaving ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLoopVectorization(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="LLVMBool") boolean LoopVectorization) {
        long __functionAddress = Functions.PassBuilderOptionsSetLoopVectorization;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, LoopVectorization ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetSLPVectorization(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="LLVMBool") boolean SLPVectorization) {
        long __functionAddress = Functions.PassBuilderOptionsSetSLPVectorization;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, SLPVectorization ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLoopUnrolling(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="LLVMBool") boolean LoopUnrolling) {
        long __functionAddress = Functions.PassBuilderOptionsSetLoopUnrolling;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, LoopUnrolling ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetForgetAllSCEVInLoopUnroll(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="LLVMBool") boolean ForgetAllSCEVInLoopUnroll) {
        long __functionAddress = Functions.PassBuilderOptionsSetForgetAllSCEVInLoopUnroll;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, ForgetAllSCEVInLoopUnroll ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLicmMssaOptCap(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="unsigned") int LicmMssaOptCap) {
        long __functionAddress = Functions.PassBuilderOptionsSetLicmMssaOptCap;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, LicmMssaOptCap, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLicmMssaNoAccForPromotionCap(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="unsigned") int LicmMssaNoAccForPromotionCap) {
        long __functionAddress = Functions.PassBuilderOptionsSetLicmMssaNoAccForPromotionCap;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, LicmMssaNoAccForPromotionCap, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetCallGraphProfile(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="LLVMBool") boolean CallGraphProfile) {
        long __functionAddress = Functions.PassBuilderOptionsSetCallGraphProfile;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, CallGraphProfile ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetMergeFunctions(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2, @NativeType(value="LLVMBool") boolean MergeFunctions) {
        long __functionAddress = Functions.PassBuilderOptionsSetMergeFunctions;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, MergeFunctions ? 1 : 0, __functionAddress);
    }

    public static void LLVMDisposePassBuilderOptions(@NativeType(value="LLVMPassBuilderOptionsRef") long Options2) {
        long __functionAddress = Functions.DisposePassBuilderOptions;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Options2);
        }
        JNI.invokePV(Options2, __functionAddress);
    }

    @NativeType(value="LLVMPassManagerBuilderRef")
    public static long LLVMPassManagerBuilderCreate() {
        long __functionAddress = Functions.PassManagerBuilderCreate;
        return JNI.invokeP(__functionAddress);
    }

    public static void LLVMPassManagerBuilderDispose(@NativeType(value="LLVMPassManagerBuilderRef") long PMB) {
        long __functionAddress = Functions.PassManagerBuilderDispose;
        if (Checks.CHECKS) {
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, __functionAddress);
    }

    public static void LLVMPassManagerBuilderSetOptLevel(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="unsigned int") int OptLevel) {
        long __functionAddress = Functions.PassManagerBuilderSetOptLevel;
        if (Checks.CHECKS) {
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, OptLevel, __functionAddress);
    }

    public static void LLVMPassManagerBuilderSetSizeLevel(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="unsigned int") int SizeLevel) {
        long __functionAddress = Functions.PassManagerBuilderSetSizeLevel;
        if (Checks.CHECKS) {
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, SizeLevel, __functionAddress);
    }

    public static void LLVMPassManagerBuilderSetDisableUnitAtATime(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMBool") boolean Value) {
        long __functionAddress = Functions.PassManagerBuilderSetDisableUnitAtATime;
        if (Checks.CHECKS) {
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, Value ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassManagerBuilderSetDisableUnrollLoops(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMBool") boolean Value) {
        long __functionAddress = Functions.PassManagerBuilderSetDisableUnrollLoops;
        if (Checks.CHECKS) {
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, Value ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassManagerBuilderSetDisableSimplifyLibCalls(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMBool") boolean Value) {
        long __functionAddress = Functions.PassManagerBuilderSetDisableSimplifyLibCalls;
        if (Checks.CHECKS) {
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, Value ? 1 : 0, __functionAddress);
    }

    public static void LLVMPassManagerBuilderUseInlinerWithThreshold(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="unsigned int") int Threshold) {
        long __functionAddress = Functions.PassManagerBuilderUseInlinerWithThreshold;
        if (Checks.CHECKS) {
            Checks.check(PMB);
        }
        JNI.invokePV(PMB, Threshold, __functionAddress);
    }

    public static void LLVMPassManagerBuilderPopulateFunctionPassManager(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.PassManagerBuilderPopulateFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check(PMB);
            Checks.check(PM);
        }
        JNI.invokePPV(PMB, PM, __functionAddress);
    }

    public static void LLVMPassManagerBuilderPopulateModulePassManager(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.PassManagerBuilderPopulateModulePassManager;
        if (Checks.CHECKS) {
            Checks.check(PMB);
            Checks.check(PM);
        }
        JNI.invokePPV(PMB, PM, __functionAddress);
    }

    public static void LLVMPassManagerBuilderPopulateLTOPassManager(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="LLVMBool") boolean Internalize, @NativeType(value="LLVMBool") boolean RunInliner) {
        long __functionAddress = Functions.PassManagerBuilderPopulateLTOPassManager;
        if (Checks.CHECKS) {
            Checks.check(PMB);
            Checks.check(PM);
        }
        JNI.invokePPV(PMB, PM, Internalize ? 1 : 0, RunInliner ? 1 : 0, __functionAddress);
    }

    public static void LLVMAddAggressiveDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAggressiveDCEPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDCEPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddBitTrackingDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddBitTrackingDCEPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddAlignmentFromAssumptionsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAlignmentFromAssumptionsPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCFGSimplificationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCFGSimplificationPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddDeadStoreEliminationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDeadStoreEliminationPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddScalarizerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScalarizerPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddMergedLoadStoreMotionPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddMergedLoadStoreMotionPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddGVNPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddGVNPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddNewGVNPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddNewGVNPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddIndVarSimplifyPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddIndVarSimplifyPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddJumpThreadingPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddJumpThreadingPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLICMPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLICMPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopDeletionPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopDeletionPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopIdiomPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopIdiomPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopRotatePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopRotatePass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopRerollPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopRerollPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopUnrollPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopUnrollPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopUnrollAndJamPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopUnrollAndJamPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopUnswitchPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopUnswitchPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLowerAtomicPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerAtomicPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddMemCpyOptPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddMemCpyOptPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddPartiallyInlineLibCallsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddPartiallyInlineLibCallsPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddReassociatePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddReassociatePass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddSCCPPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddSCCPPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddScalarReplAggregatesPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScalarReplAggregatesPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddScalarReplAggregatesPassSSA(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScalarReplAggregatesPassSSA;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddScalarReplAggregatesPassWithThreshold(@NativeType(value="LLVMPassManagerRef") long PM, int Threshold) {
        long __functionAddress = Functions.AddScalarReplAggregatesPassWithThreshold;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, Threshold, __functionAddress);
    }

    public static void LLVMAddSimplifyLibCallsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddSimplifyLibCallsPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddTailCallEliminationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddTailCallEliminationPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddConstantPropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddConstantPropagationPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddDemoteMemoryToRegisterPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDemoteMemoryToRegisterPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddVerifierPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddVerifierPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddCorrelatedValuePropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCorrelatedValuePropagationPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddEarlyCSEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddEarlyCSEPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddEarlyCSEMemSSAPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddEarlyCSEMemSSAPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLowerExpectIntrinsicPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerExpectIntrinsicPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLowerConstantIntrinsicsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerConstantIntrinsicsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddTypeBasedAliasAnalysisPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddTypeBasedAliasAnalysisPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddScopedNoAliasAAPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScopedNoAliasAAPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddBasicAliasAnalysisPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddBasicAliasAnalysisPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddUnifyFunctionExitNodesPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddUnifyFunctionExitNodesPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLowerSwitchPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerSwitchPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddPromoteMemoryToRegisterPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddPromoteMemoryToRegisterPass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddAddDiscriminatorsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAddDiscriminatorsPass;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddLoopVectorizePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopVectorizePass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static void LLVMAddSLPVectorizePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddSLPVectorizePass;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    public static final class Functions {
        public static final long AddAggressiveInstCombinerPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddAggressiveInstCombinerPass");
        public static final long AddCoroEarlyPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddCoroEarlyPass");
        public static final long AddCoroSplitPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddCoroSplitPass");
        public static final long AddCoroElidePass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddCoroElidePass");
        public static final long AddCoroCleanupPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddCoroCleanupPass");
        public static final long PassManagerBuilderAddCoroutinePassesToExtensionPoints = LLVMCore.getLibrary().getFunctionAddress("LLVMPassManagerBuilderAddCoroutinePassesToExtensionPoints");
        public static final long AddInstructionCombiningPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddInstructionCombiningPass");
        public static final long AddInstructionSimplifyPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddInstructionSimplifyPass");
        public static final long AddArgumentPromotionPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddArgumentPromotionPass");
        public static final long AddConstantMergePass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddConstantMergePass");
        public static final long AddMergeFunctionsPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddMergeFunctionsPass");
        public static final long AddCalledValuePropagationPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddCalledValuePropagationPass");
        public static final long AddDeadArgEliminationPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddDeadArgEliminationPass");
        public static final long AddFunctionAttrsPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddFunctionAttrsPass");
        public static final long AddFunctionInliningPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddFunctionInliningPass");
        public static final long AddAlwaysInlinerPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddAlwaysInlinerPass");
        public static final long AddGlobalDCEPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddGlobalDCEPass");
        public static final long AddGlobalOptimizerPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddGlobalOptimizerPass");
        public static final long AddIPConstantPropagationPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddIPConstantPropagationPass");
        public static final long AddPruneEHPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddPruneEHPass");
        public static final long AddIPSCCPPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddIPSCCPPass");
        public static final long AddInternalizePass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddInternalizePass");
        public static final long AddInternalizePassWithMustPreservePredicate = LLVMCore.getLibrary().getFunctionAddress("LLVMAddInternalizePassWithMustPreservePredicate");
        public static final long AddStripDeadPrototypesPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddStripDeadPrototypesPass");
        public static final long AddStripSymbolsPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddStripSymbolsPass");
        public static final long RunPasses = LLVMCore.getLibrary().getFunctionAddress("LLVMRunPasses");
        public static final long CreatePassBuilderOptions = LLVMCore.getLibrary().getFunctionAddress("LLVMCreatePassBuilderOptions");
        public static final long PassBuilderOptionsSetVerifyEach = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetVerifyEach");
        public static final long PassBuilderOptionsSetDebugLogging = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetDebugLogging");
        public static final long PassBuilderOptionsSetLoopInterleaving = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetLoopInterleaving");
        public static final long PassBuilderOptionsSetLoopVectorization = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetLoopVectorization");
        public static final long PassBuilderOptionsSetSLPVectorization = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetSLPVectorization");
        public static final long PassBuilderOptionsSetLoopUnrolling = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetLoopUnrolling");
        public static final long PassBuilderOptionsSetForgetAllSCEVInLoopUnroll = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetForgetAllSCEVInLoopUnroll");
        public static final long PassBuilderOptionsSetLicmMssaOptCap = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetLicmMssaOptCap");
        public static final long PassBuilderOptionsSetLicmMssaNoAccForPromotionCap = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetLicmMssaNoAccForPromotionCap");
        public static final long PassBuilderOptionsSetCallGraphProfile = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetCallGraphProfile");
        public static final long PassBuilderOptionsSetMergeFunctions = LLVMCore.getLibrary().getFunctionAddress("LLVMPassBuilderOptionsSetMergeFunctions");
        public static final long DisposePassBuilderOptions = LLVMCore.getLibrary().getFunctionAddress("LLVMDisposePassBuilderOptions");
        public static final long PassManagerBuilderCreate = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderCreate");
        public static final long PassManagerBuilderDispose = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderDispose");
        public static final long PassManagerBuilderSetOptLevel = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderSetOptLevel");
        public static final long PassManagerBuilderSetSizeLevel = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderSetSizeLevel");
        public static final long PassManagerBuilderSetDisableUnitAtATime = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderSetDisableUnitAtATime");
        public static final long PassManagerBuilderSetDisableUnrollLoops = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderSetDisableUnrollLoops");
        public static final long PassManagerBuilderSetDisableSimplifyLibCalls = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderSetDisableSimplifyLibCalls");
        public static final long PassManagerBuilderUseInlinerWithThreshold = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderUseInlinerWithThreshold");
        public static final long PassManagerBuilderPopulateFunctionPassManager = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderPopulateFunctionPassManager");
        public static final long PassManagerBuilderPopulateModulePassManager = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderPopulateModulePassManager");
        public static final long PassManagerBuilderPopulateLTOPassManager = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMPassManagerBuilderPopulateLTOPassManager");
        public static final long AddAggressiveDCEPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddAggressiveDCEPass");
        public static final long AddDCEPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddDCEPass");
        public static final long AddBitTrackingDCEPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddBitTrackingDCEPass");
        public static final long AddAlignmentFromAssumptionsPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddAlignmentFromAssumptionsPass");
        public static final long AddCFGSimplificationPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddCFGSimplificationPass");
        public static final long AddDeadStoreEliminationPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddDeadStoreEliminationPass");
        public static final long AddScalarizerPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddScalarizerPass");
        public static final long AddMergedLoadStoreMotionPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddMergedLoadStoreMotionPass");
        public static final long AddGVNPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddGVNPass");
        public static final long AddNewGVNPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddNewGVNPass");
        public static final long AddIndVarSimplifyPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddIndVarSimplifyPass");
        public static final long AddJumpThreadingPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddJumpThreadingPass");
        public static final long AddLICMPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddLICMPass");
        public static final long AddLoopDeletionPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddLoopDeletionPass");
        public static final long AddLoopIdiomPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddLoopIdiomPass");
        public static final long AddLoopRotatePass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddLoopRotatePass");
        public static final long AddLoopRerollPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddLoopRerollPass");
        public static final long AddLoopUnrollPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddLoopUnrollPass");
        public static final long AddLoopUnrollAndJamPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddLoopUnrollAndJamPass");
        public static final long AddLoopUnswitchPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddLoopUnswitchPass");
        public static final long AddLowerAtomicPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddLowerAtomicPass");
        public static final long AddMemCpyOptPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddMemCpyOptPass");
        public static final long AddPartiallyInlineLibCallsPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddPartiallyInlineLibCallsPass");
        public static final long AddReassociatePass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddReassociatePass");
        public static final long AddSCCPPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddSCCPPass");
        public static final long AddScalarReplAggregatesPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddScalarReplAggregatesPass");
        public static final long AddScalarReplAggregatesPassSSA = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddScalarReplAggregatesPassSSA");
        public static final long AddScalarReplAggregatesPassWithThreshold = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddScalarReplAggregatesPassWithThreshold");
        public static final long AddSimplifyLibCallsPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddSimplifyLibCallsPass");
        public static final long AddTailCallEliminationPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddTailCallEliminationPass");
        public static final long AddConstantPropagationPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddConstantPropagationPass");
        public static final long AddDemoteMemoryToRegisterPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddDemoteMemoryToRegisterPass");
        public static final long AddVerifierPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddVerifierPass");
        public static final long AddCorrelatedValuePropagationPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddCorrelatedValuePropagationPass");
        public static final long AddEarlyCSEPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddEarlyCSEPass");
        public static final long AddEarlyCSEMemSSAPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddEarlyCSEMemSSAPass");
        public static final long AddLowerExpectIntrinsicPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddLowerExpectIntrinsicPass");
        public static final long AddLowerConstantIntrinsicsPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddLowerConstantIntrinsicsPass");
        public static final long AddTypeBasedAliasAnalysisPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddTypeBasedAliasAnalysisPass");
        public static final long AddScopedNoAliasAAPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddScopedNoAliasAAPass");
        public static final long AddBasicAliasAnalysisPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddBasicAliasAnalysisPass");
        public static final long AddUnifyFunctionExitNodesPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddUnifyFunctionExitNodesPass");
        public static final long AddLowerSwitchPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddLowerSwitchPass");
        public static final long AddPromoteMemoryToRegisterPass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddPromoteMemoryToRegisterPass");
        public static final long AddAddDiscriminatorsPass = LLVMCore.getLibrary().getFunctionAddress("LLVMAddAddDiscriminatorsPass");
        public static final long AddLoopVectorizePass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddLoopVectorizePass");
        public static final long AddSLPVectorizePass = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddSLPVectorizePass");

        private Functions() {
        }
    }
}

