/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LTOObjectBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int SIZE;

    public LTOObjectBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LTOObjectBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer Buffer() {
        return LTOObjectBuffer.nBuffer(this.address());
    }

    @NativeType(value="size_t")
    public long Size() {
        return LTOObjectBuffer.nSize(this.address());
    }

    public static LTOObjectBuffer malloc() {
        return LTOObjectBuffer.wrap(LTOObjectBuffer.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LTOObjectBuffer calloc() {
        return LTOObjectBuffer.wrap(LTOObjectBuffer.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LTOObjectBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LTOObjectBuffer.wrap(LTOObjectBuffer.class, MemoryUtil.memAddress(container), container);
    }

    public static LTOObjectBuffer create(long address) {
        return LTOObjectBuffer.wrap(LTOObjectBuffer.class, address);
    }

    @Nullable
    public static LTOObjectBuffer createSafe(long address) {
        return address == 0L ? null : LTOObjectBuffer.wrap(LTOObjectBuffer.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LTOObjectBuffer.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LTOObjectBuffer.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LTOObjectBuffer.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LTOObjectBuffer.__create(capacity, SIZEOF);
        return LTOObjectBuffer.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LTOObjectBuffer.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LTOObjectBuffer.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static LTOObjectBuffer mallocStack() {
        return LTOObjectBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LTOObjectBuffer callocStack() {
        return LTOObjectBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LTOObjectBuffer mallocStack(MemoryStack stack) {
        return LTOObjectBuffer.malloc(stack);
    }

    @Deprecated
    public static LTOObjectBuffer callocStack(MemoryStack stack) {
        return LTOObjectBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LTOObjectBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LTOObjectBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LTOObjectBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LTOObjectBuffer.calloc(capacity, stack);
    }

    public static LTOObjectBuffer malloc(MemoryStack stack) {
        return LTOObjectBuffer.wrap(LTOObjectBuffer.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LTOObjectBuffer calloc(MemoryStack stack) {
        return LTOObjectBuffer.wrap(LTOObjectBuffer.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LTOObjectBuffer.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LTOObjectBuffer.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nBuffer(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)BUFFER), (int)LTOObjectBuffer.nSize(struct));
    }

    public static long nSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    static {
        Struct.Layout layout = LTOObjectBuffer.__struct(LTOObjectBuffer.__member(POINTER_SIZE), LTOObjectBuffer.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LTOObjectBuffer, Buffer>
    implements NativeResource {
        private static final LTOObjectBuffer ELEMENT_FACTORY = LTOObjectBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LTOObjectBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer Buffer() {
            return LTOObjectBuffer.nBuffer(this.address());
        }

        @NativeType(value="size_t")
        public long Size() {
            return LTOObjectBuffer.nSize(this.address());
        }
    }
}

