/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkBuffer;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_command_buffer")
public class NkCommandBuffer
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BASE;
    public static final int CLIP;
    public static final int USE_CLIPPING;
    public static final int USERDATA;
    public static final int BEGIN;
    public static final int END;
    public static final int LAST;

    public NkCommandBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkCommandBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="struct nk_buffer *")
    public NkBuffer base() {
        return NkCommandBuffer.nbase(this.address());
    }

    @NativeType(value="struct nk_rect")
    public NkRect clip() {
        return NkCommandBuffer.nclip(this.address());
    }

    public int use_clipping() {
        return NkCommandBuffer.nuse_clipping(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkCommandBuffer.nuserdata(this.address());
    }

    @NativeType(value="nk_size")
    public long begin() {
        return NkCommandBuffer.nbegin(this.address());
    }

    @NativeType(value="nk_size")
    public long end() {
        return NkCommandBuffer.nend(this.address());
    }

    @NativeType(value="nk_size")
    public long last() {
        return NkCommandBuffer.nlast(this.address());
    }

    public static NkCommandBuffer create(long address) {
        return NkCommandBuffer.wrap(NkCommandBuffer.class, address);
    }

    @Nullable
    public static NkCommandBuffer createSafe(long address) {
        return address == 0L ? null : NkCommandBuffer.wrap(NkCommandBuffer.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return NkCommandBuffer.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkCommandBuffer.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static NkBuffer nbase(long struct) {
        return NkBuffer.createSafe(MemoryUtil.memGetAddress(struct + (long)BASE));
    }

    public static NkRect nclip(long struct) {
        return NkRect.create(struct + (long)CLIP);
    }

    public static int nuse_clipping(long struct) {
        return UNSAFE.getInt(null, struct + (long)USE_CLIPPING);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static long nbegin(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BEGIN);
    }

    public static long nend(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)END);
    }

    public static long nlast(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LAST);
    }

    static {
        Struct.Layout layout = NkCommandBuffer.__struct(NkCommandBuffer.__member(POINTER_SIZE), NkCommandBuffer.__member(NkRect.SIZEOF, NkRect.ALIGNOF), NkCommandBuffer.__member(4), NkCommandBuffer.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkCommandBuffer.__member(POINTER_SIZE), NkCommandBuffer.__member(POINTER_SIZE), NkCommandBuffer.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BASE = layout.offsetof(0);
        CLIP = layout.offsetof(1);
        USE_CLIPPING = layout.offsetof(2);
        USERDATA = layout.offsetof(3);
        BEGIN = layout.offsetof(4);
        END = layout.offsetof(5);
        LAST = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<NkCommandBuffer, Buffer> {
        private static final NkCommandBuffer ELEMENT_FACTORY = NkCommandBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkCommandBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="struct nk_buffer *")
        public NkBuffer base() {
            return NkCommandBuffer.nbase(this.address());
        }

        @NativeType(value="struct nk_rect")
        public NkRect clip() {
            return NkCommandBuffer.nclip(this.address());
        }

        public int use_clipping() {
            return NkCommandBuffer.nuse_clipping(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkCommandBuffer.nuserdata(this.address());
        }

        @NativeType(value="nk_size")
        public long begin() {
            return NkCommandBuffer.nbegin(this.address());
        }

        @NativeType(value="nk_size")
        public long end() {
            return NkCommandBuffer.nend(this.address());
        }

        @NativeType(value="nk_size")
        public long last() {
            return NkCommandBuffer.nlast(this.address());
        }
    }
}

