/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_image")
public class NkImage
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int W;
    public static final int H;
    public static final int REGION;

    public NkImage(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkImage.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_handle")
    public NkHandle handle() {
        return NkImage.nhandle(this.address());
    }

    @NativeType(value="nk_ushort")
    public short w() {
        return NkImage.nw(this.address());
    }

    @NativeType(value="nk_ushort")
    public short h() {
        return NkImage.nh(this.address());
    }

    @NativeType(value="nk_ushort[4]")
    public ShortBuffer region() {
        return NkImage.nregion(this.address());
    }

    @NativeType(value="nk_ushort")
    public short region(int index) {
        return NkImage.nregion(this.address(), index);
    }

    public NkImage handle(@NativeType(value="nk_handle") NkHandle value) {
        NkImage.nhandle(this.address(), value);
        return this;
    }

    public NkImage handle(Consumer<NkHandle> consumer) {
        consumer.accept(this.handle());
        return this;
    }

    public NkImage w(@NativeType(value="nk_ushort") short value) {
        NkImage.nw(this.address(), value);
        return this;
    }

    public NkImage h(@NativeType(value="nk_ushort") short value) {
        NkImage.nh(this.address(), value);
        return this;
    }

    public NkImage region(@NativeType(value="nk_ushort[4]") ShortBuffer value) {
        NkImage.nregion(this.address(), value);
        return this;
    }

    public NkImage region(int index, @NativeType(value="nk_ushort") short value) {
        NkImage.nregion(this.address(), index, value);
        return this;
    }

    public NkImage set(NkHandle handle, short w, short h, ShortBuffer region) {
        this.handle(handle);
        this.w(w);
        this.h(h);
        this.region(region);
        return this;
    }

    public NkImage set(NkImage src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkImage malloc() {
        return NkImage.wrap(NkImage.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkImage calloc() {
        return NkImage.wrap(NkImage.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkImage create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NkImage.wrap(NkImage.class, MemoryUtil.memAddress(container), container);
    }

    public static NkImage create(long address) {
        return NkImage.wrap(NkImage.class, address);
    }

    @Nullable
    public static NkImage createSafe(long address) {
        return address == 0L ? null : NkImage.wrap(NkImage.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NkImage.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NkImage.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkImage.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkImage.__create(capacity, SIZEOF);
        return NkImage.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NkImage.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkImage.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NkImage mallocStack() {
        return NkImage.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkImage callocStack() {
        return NkImage.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkImage mallocStack(MemoryStack stack) {
        return NkImage.malloc(stack);
    }

    @Deprecated
    public static NkImage callocStack(MemoryStack stack) {
        return NkImage.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkImage.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkImage.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkImage.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkImage.calloc(capacity, stack);
    }

    public static NkImage malloc(MemoryStack stack) {
        return NkImage.wrap(NkImage.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkImage calloc(MemoryStack stack) {
        return NkImage.wrap(NkImage.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NkImage.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NkImage.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkHandle nhandle(long struct) {
        return NkHandle.create(struct + (long)HANDLE);
    }

    public static short nw(long struct) {
        return UNSAFE.getShort(null, struct + (long)W);
    }

    public static short nh(long struct) {
        return UNSAFE.getShort(null, struct + (long)H);
    }

    public static ShortBuffer nregion(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)REGION, 4);
    }

    public static short nregion(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)REGION + Checks.check(index, 4) * 2L);
    }

    public static void nhandle(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HANDLE, NkHandle.SIZEOF);
    }

    public static void nw(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)W, value);
    }

    public static void nh(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)H, value);
    }

    public static void nregion(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)REGION, value.remaining() * 2);
    }

    public static void nregion(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)REGION + Checks.check(index, 4) * 2L, value);
    }

    static {
        Struct.Layout layout = NkImage.__struct(NkImage.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkImage.__member(2), NkImage.__member(2), NkImage.__array(2, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        W = layout.offsetof(1);
        H = layout.offsetof(2);
        REGION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkImage, Buffer>
    implements NativeResource {
        private static final NkImage ELEMENT_FACTORY = NkImage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkImage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_handle")
        public NkHandle handle() {
            return NkImage.nhandle(this.address());
        }

        @NativeType(value="nk_ushort")
        public short w() {
            return NkImage.nw(this.address());
        }

        @NativeType(value="nk_ushort")
        public short h() {
            return NkImage.nh(this.address());
        }

        @NativeType(value="nk_ushort[4]")
        public ShortBuffer region() {
            return NkImage.nregion(this.address());
        }

        @NativeType(value="nk_ushort")
        public short region(int index) {
            return NkImage.nregion(this.address(), index);
        }

        public Buffer handle(@NativeType(value="nk_handle") NkHandle value) {
            NkImage.nhandle(this.address(), value);
            return this;
        }

        public Buffer handle(Consumer<NkHandle> consumer) {
            consumer.accept(this.handle());
            return this;
        }

        public Buffer w(@NativeType(value="nk_ushort") short value) {
            NkImage.nw(this.address(), value);
            return this;
        }

        public Buffer h(@NativeType(value="nk_ushort") short value) {
            NkImage.nh(this.address(), value);
            return this;
        }

        public Buffer region(@NativeType(value="nk_ushort[4]") ShortBuffer value) {
            NkImage.nregion(this.address(), value);
            return this;
        }

        public Buffer region(int index, @NativeType(value="nk_ushort") short value) {
            NkImage.nregion(this.address(), index, value);
            return this;
        }
    }
}

