/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkKey;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_keyboard")
public class NkKeyboard
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KEYS;
    public static final int TEXT;
    public static final int TEXT_LEN;

    public NkKeyboard(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkKeyboard.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_key[NK_KEY_MAX]")
    public NkKey.Buffer keys() {
        return NkKeyboard.nkeys(this.address());
    }

    @NativeType(value="struct nk_key")
    public NkKey keys(int index) {
        return NkKeyboard.nkeys(this.address(), index);
    }

    @NativeType(value="char[NK_INPUT_MAX]")
    public ByteBuffer text() {
        return NkKeyboard.ntext(this.address());
    }

    @NativeType(value="char")
    public byte text(int index) {
        return NkKeyboard.ntext(this.address(), index);
    }

    public int text_len() {
        return NkKeyboard.ntext_len(this.address());
    }

    public static NkKeyboard create(long address) {
        return NkKeyboard.wrap(NkKeyboard.class, address);
    }

    @Nullable
    public static NkKeyboard createSafe(long address) {
        return address == 0L ? null : NkKeyboard.wrap(NkKeyboard.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return NkKeyboard.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkKeyboard.wrap(Buffer.class, address, capacity);
    }

    public static NkKey.Buffer nkeys(long struct) {
        return NkKey.create(struct + (long)KEYS, 30);
    }

    public static NkKey nkeys(long struct, int index) {
        return NkKey.create(struct + (long)KEYS + Checks.check(index, 30) * (long)NkKey.SIZEOF);
    }

    public static ByteBuffer ntext(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)TEXT, 16);
    }

    public static byte ntext(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)TEXT + Checks.check(index, 16) * 1L);
    }

    public static int ntext_len(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEXT_LEN);
    }

    static {
        Struct.Layout layout = NkKeyboard.__struct(NkKeyboard.__array(NkKey.SIZEOF, NkKey.ALIGNOF, 30), NkKeyboard.__array(1, 16), NkKeyboard.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KEYS = layout.offsetof(0);
        TEXT = layout.offsetof(1);
        TEXT_LEN = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkKeyboard, Buffer> {
        private static final NkKeyboard ELEMENT_FACTORY = NkKeyboard.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkKeyboard getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_key[NK_KEY_MAX]")
        public NkKey.Buffer keys() {
            return NkKeyboard.nkeys(this.address());
        }

        @NativeType(value="struct nk_key")
        public NkKey keys(int index) {
            return NkKeyboard.nkeys(this.address(), index);
        }

        @NativeType(value="char[NK_INPUT_MAX]")
        public ByteBuffer text() {
            return NkKeyboard.ntext(this.address());
        }

        @NativeType(value="char")
        public byte text(int index) {
            return NkKeyboard.ntext(this.address(), index);
        }

        public int text_len() {
            return NkKeyboard.ntext_len(this.address());
        }
    }
}

