/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_memory")
public class NkMemory
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR;
    public static final int SIZE;

    public NkMemory(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkMemory.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="void *")
    public ByteBuffer ptr() {
        return NkMemory.nptr(this.address());
    }

    @NativeType(value="nk_size")
    public long size() {
        return NkMemory.nsize(this.address());
    }

    public static NkMemory create(long address) {
        return NkMemory.wrap(NkMemory.class, address);
    }

    @Nullable
    public static NkMemory createSafe(long address) {
        return address == 0L ? null : NkMemory.wrap(NkMemory.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return NkMemory.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkMemory.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static ByteBuffer nptr(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)PTR), (int)NkMemory.nsize(struct));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    static {
        Struct.Layout layout = NkMemory.__struct(NkMemory.__member(POINTER_SIZE), NkMemory.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkMemory, Buffer> {
        private static final NkMemory ELEMENT_FACTORY = NkMemory.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkMemory getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="void *")
        public ByteBuffer ptr() {
            return NkMemory.nptr(this.address());
        }

        @NativeType(value="nk_size")
        public long size() {
            return NkMemory.nsize(this.address());
        }
    }
}

