/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkScroll;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_menu_state")
public class NkMenuState
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;
    public static final int OFFSET;

    public NkMenuState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkMenuState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return NkMenuState.nx(this.address());
    }

    public float y() {
        return NkMenuState.ny(this.address());
    }

    public float w() {
        return NkMenuState.nw(this.address());
    }

    public float h() {
        return NkMenuState.nh(this.address());
    }

    @NativeType(value="struct nk_scroll")
    public NkScroll offset() {
        return NkMenuState.noffset(this.address());
    }

    public static NkMenuState create(long address) {
        return NkMenuState.wrap(NkMenuState.class, address);
    }

    @Nullable
    public static NkMenuState createSafe(long address) {
        return address == 0L ? null : NkMenuState.wrap(NkMenuState.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return NkMenuState.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkMenuState.wrap(Buffer.class, address, capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static float nh(long struct) {
        return UNSAFE.getFloat(null, struct + (long)H);
    }

    public static NkScroll noffset(long struct) {
        return NkScroll.create(struct + (long)OFFSET);
    }

    static {
        Struct.Layout layout = NkMenuState.__struct(NkMenuState.__member(4), NkMenuState.__member(4), NkMenuState.__member(4), NkMenuState.__member(4), NkMenuState.__member(NkScroll.SIZEOF, NkScroll.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        W = layout.offsetof(2);
        H = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<NkMenuState, Buffer> {
        private static final NkMenuState ELEMENT_FACTORY = NkMenuState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkMenuState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return NkMenuState.nx(this.address());
        }

        public float y() {
            return NkMenuState.ny(this.address());
        }

        public float w() {
            return NkMenuState.nw(this.address());
        }

        public float h() {
            return NkMenuState.nh(this.address());
        }

        @NativeType(value="struct nk_scroll")
        public NkScroll offset() {
            return NkMenuState.noffset(this.address());
        }
    }
}

