/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_row_layout")
public class NkRowLayout
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int INDEX;
    public static final int HEIGHT;
    public static final int MIN_HEIGHT;
    public static final int COLUMNS;
    public static final int RATIO;
    public static final int ITEM_WIDTH;
    public static final int ITEM_HEIGHT;
    public static final int ITEM_OFFSET;
    public static final int FILLED;
    public static final int ITEM;
    public static final int TREE_DEPTH;
    public static final int TEMPLATES;

    public NkRowLayout(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkRowLayout.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum nk_panel_row_layout_type")
    public int type() {
        return NkRowLayout.ntype(this.address());
    }

    public int index() {
        return NkRowLayout.nindex(this.address());
    }

    public float height() {
        return NkRowLayout.nheight(this.address());
    }

    public float min_height() {
        return NkRowLayout.nmin_height(this.address());
    }

    public int columns() {
        return NkRowLayout.ncolumns(this.address());
    }

    @NativeType(value="float const *")
    public FloatBuffer ratio(int capacity) {
        return NkRowLayout.nratio(this.address(), capacity);
    }

    public float item_width() {
        return NkRowLayout.nitem_width(this.address());
    }

    public float item_height() {
        return NkRowLayout.nitem_height(this.address());
    }

    public float item_offset() {
        return NkRowLayout.nitem_offset(this.address());
    }

    public float filled() {
        return NkRowLayout.nfilled(this.address());
    }

    @NativeType(value="struct nk_rect")
    public NkRect item() {
        return NkRowLayout.nitem(this.address());
    }

    public int tree_depth() {
        return NkRowLayout.ntree_depth(this.address());
    }

    @NativeType(value="float[16]")
    public FloatBuffer templates() {
        return NkRowLayout.ntemplates(this.address());
    }

    public float templates(int index) {
        return NkRowLayout.ntemplates(this.address(), index);
    }

    public static NkRowLayout create(long address) {
        return NkRowLayout.wrap(NkRowLayout.class, address);
    }

    @Nullable
    public static NkRowLayout createSafe(long address) {
        return address == 0L ? null : NkRowLayout.wrap(NkRowLayout.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return NkRowLayout.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkRowLayout.wrap(Buffer.class, address, capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int nindex(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEX);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static float nmin_height(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MIN_HEIGHT);
    }

    public static int ncolumns(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLUMNS);
    }

    public static FloatBuffer nratio(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)RATIO), capacity);
    }

    public static float nitem_width(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ITEM_WIDTH);
    }

    public static float nitem_height(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ITEM_HEIGHT);
    }

    public static float nitem_offset(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ITEM_OFFSET);
    }

    public static float nfilled(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FILLED);
    }

    public static NkRect nitem(long struct) {
        return NkRect.create(struct + (long)ITEM);
    }

    public static int ntree_depth(long struct) {
        return UNSAFE.getInt(null, struct + (long)TREE_DEPTH);
    }

    public static FloatBuffer ntemplates(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)TEMPLATES, 16);
    }

    public static float ntemplates(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)TEMPLATES + Checks.check(index, 16) * 4L);
    }

    static {
        Struct.Layout layout = NkRowLayout.__struct(NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(POINTER_SIZE), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(4), NkRowLayout.__member(NkRect.SIZEOF, NkRect.ALIGNOF), NkRowLayout.__member(4), NkRowLayout.__array(4, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        INDEX = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        MIN_HEIGHT = layout.offsetof(3);
        COLUMNS = layout.offsetof(4);
        RATIO = layout.offsetof(5);
        ITEM_WIDTH = layout.offsetof(6);
        ITEM_HEIGHT = layout.offsetof(7);
        ITEM_OFFSET = layout.offsetof(8);
        FILLED = layout.offsetof(9);
        ITEM = layout.offsetof(10);
        TREE_DEPTH = layout.offsetof(11);
        TEMPLATES = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<NkRowLayout, Buffer> {
        private static final NkRowLayout ELEMENT_FACTORY = NkRowLayout.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkRowLayout getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum nk_panel_row_layout_type")
        public int type() {
            return NkRowLayout.ntype(this.address());
        }

        public int index() {
            return NkRowLayout.nindex(this.address());
        }

        public float height() {
            return NkRowLayout.nheight(this.address());
        }

        public float min_height() {
            return NkRowLayout.nmin_height(this.address());
        }

        public int columns() {
            return NkRowLayout.ncolumns(this.address());
        }

        @NativeType(value="float const *")
        public FloatBuffer ratio(int capacity) {
            return NkRowLayout.nratio(this.address(), capacity);
        }

        public float item_width() {
            return NkRowLayout.nitem_width(this.address());
        }

        public float item_height() {
            return NkRowLayout.nitem_height(this.address());
        }

        public float item_offset() {
            return NkRowLayout.nitem_offset(this.address());
        }

        public float filled() {
            return NkRowLayout.nfilled(this.address());
        }

        @NativeType(value="struct nk_rect")
        public NkRect item() {
            return NkRowLayout.nitem(this.address());
        }

        public int tree_depth() {
            return NkRowLayout.ntree_depth(this.address());
        }

        @NativeType(value="float[16]")
        public FloatBuffer templates() {
            return NkRowLayout.ntemplates(this.address());
        }

        public float templates(int index) {
            return NkRowLayout.ntemplates(this.address(), index);
        }
    }
}

