/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_chart")
public class NkStyleChart
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACKGROUND;
    public static final int BORDER_COLOR;
    public static final int SELECTED_COLOR;
    public static final int COLOR;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int PADDING;

    public NkStyleChart(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkStyleChart.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem background() {
        return NkStyleChart.nbackground(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleChart.nborder_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor selected_color() {
        return NkStyleChart.nselected_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor color() {
        return NkStyleChart.ncolor(this.address());
    }

    public float border() {
        return NkStyleChart.nborder(this.address());
    }

    public float rounding() {
        return NkStyleChart.nrounding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleChart.npadding(this.address());
    }

    public NkStyleChart background(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleChart.nbackground(this.address(), value);
        return this;
    }

    public NkStyleChart background(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.background());
        return this;
    }

    public NkStyleChart border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleChart.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleChart border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleChart selected_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleChart.nselected_color(this.address(), value);
        return this;
    }

    public NkStyleChart selected_color(Consumer<NkColor> consumer) {
        consumer.accept(this.selected_color());
        return this;
    }

    public NkStyleChart color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleChart.ncolor(this.address(), value);
        return this;
    }

    public NkStyleChart color(Consumer<NkColor> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public NkStyleChart border(float value) {
        NkStyleChart.nborder(this.address(), value);
        return this;
    }

    public NkStyleChart rounding(float value) {
        NkStyleChart.nrounding(this.address(), value);
        return this;
    }

    public NkStyleChart padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleChart.npadding(this.address(), value);
        return this;
    }

    public NkStyleChart padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleChart set(NkStyleItem background, NkColor border_color, NkColor selected_color, NkColor color, float border, float rounding, NkVec2 padding) {
        this.background(background);
        this.border_color(border_color);
        this.selected_color(selected_color);
        this.color(color);
        this.border(border);
        this.rounding(rounding);
        this.padding(padding);
        return this;
    }

    public NkStyleChart set(NkStyleChart src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleChart malloc() {
        return NkStyleChart.wrap(NkStyleChart.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkStyleChart calloc() {
        return NkStyleChart.wrap(NkStyleChart.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkStyleChart create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NkStyleChart.wrap(NkStyleChart.class, MemoryUtil.memAddress(container), container);
    }

    public static NkStyleChart create(long address) {
        return NkStyleChart.wrap(NkStyleChart.class, address);
    }

    @Nullable
    public static NkStyleChart createSafe(long address) {
        return address == 0L ? null : NkStyleChart.wrap(NkStyleChart.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleChart.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NkStyleChart.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleChart.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleChart.__create(capacity, SIZEOF);
        return NkStyleChart.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NkStyleChart.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkStyleChart.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NkStyleChart mallocStack() {
        return NkStyleChart.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleChart callocStack() {
        return NkStyleChart.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleChart mallocStack(MemoryStack stack) {
        return NkStyleChart.malloc(stack);
    }

    @Deprecated
    public static NkStyleChart callocStack(MemoryStack stack) {
        return NkStyleChart.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleChart.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleChart.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleChart.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleChart.calloc(capacity, stack);
    }

    public static NkStyleChart malloc(MemoryStack stack) {
        return NkStyleChart.wrap(NkStyleChart.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleChart calloc(MemoryStack stack) {
        return NkStyleChart.wrap(NkStyleChart.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NkStyleChart.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NkStyleChart.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nbackground(long struct) {
        return NkStyleItem.create(struct + (long)BACKGROUND);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor nselected_color(long struct) {
        return NkColor.create(struct + (long)SELECTED_COLOR);
    }

    public static NkColor ncolor(long struct) {
        return NkColor.create(struct + (long)COLOR);
    }

    public static float nborder(long struct) {
        return UNSAFE.getFloat(null, struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ROUNDING);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static void nbackground(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BACKGROUND, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nselected_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SELECTED_COLOR, NkColor.SIZEOF);
    }

    public static void ncolor(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COLOR, NkColor.SIZEOF);
    }

    public static void nborder(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ROUNDING, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleChart.__struct(NkStyleChart.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleChart.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleChart.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleChart.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleChart.__member(4), NkStyleChart.__member(4), NkStyleChart.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACKGROUND = layout.offsetof(0);
        BORDER_COLOR = layout.offsetof(1);
        SELECTED_COLOR = layout.offsetof(2);
        COLOR = layout.offsetof(3);
        BORDER = layout.offsetof(4);
        ROUNDING = layout.offsetof(5);
        PADDING = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<NkStyleChart, Buffer>
    implements NativeResource {
        private static final NkStyleChart ELEMENT_FACTORY = NkStyleChart.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkStyleChart getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem background() {
            return NkStyleChart.nbackground(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleChart.nborder_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor selected_color() {
            return NkStyleChart.nselected_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor color() {
            return NkStyleChart.ncolor(this.address());
        }

        public float border() {
            return NkStyleChart.nborder(this.address());
        }

        public float rounding() {
            return NkStyleChart.nrounding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleChart.npadding(this.address());
        }

        public Buffer background(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleChart.nbackground(this.address(), value);
            return this;
        }

        public Buffer background(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.background());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleChart.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer selected_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleChart.nselected_color(this.address(), value);
            return this;
        }

        public Buffer selected_color(Consumer<NkColor> consumer) {
            consumer.accept(this.selected_color());
            return this;
        }

        public Buffer color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleChart.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<NkColor> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer border(float value) {
            NkStyleChart.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleChart.nrounding(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleChart.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }
    }
}

