/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleEdit;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_property")
public class NkStyleProperty
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int LABEL_NORMAL;
    public static final int LABEL_HOVER;
    public static final int LABEL_ACTIVE;
    public static final int SYM_LEFT;
    public static final int SYM_RIGHT;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int PADDING;
    public static final int EDIT;
    public static final int INC_BUTTON;
    public static final int DEC_BUTTON;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    public NkStyleProperty(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkStyleProperty.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem normal() {
        return NkStyleProperty.nnormal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem hover() {
        return NkStyleProperty.nhover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem active() {
        return NkStyleProperty.nactive(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleProperty.nborder_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor label_normal() {
        return NkStyleProperty.nlabel_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor label_hover() {
        return NkStyleProperty.nlabel_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor label_active() {
        return NkStyleProperty.nlabel_active(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int sym_left() {
        return NkStyleProperty.nsym_left(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int sym_right() {
        return NkStyleProperty.nsym_right(this.address());
    }

    public float border() {
        return NkStyleProperty.nborder(this.address());
    }

    public float rounding() {
        return NkStyleProperty.nrounding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleProperty.npadding(this.address());
    }

    @NativeType(value="struct nk_style_edit")
    public NkStyleEdit edit() {
        return NkStyleProperty.nedit(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton inc_button() {
        return NkStyleProperty.ninc_button(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton dec_button() {
        return NkStyleProperty.ndec_button(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkStyleProperty.nuserdata(this.address());
    }

    @Nullable
    @NativeType(value="nk_draw_begin")
    public NkDrawBeginCallback draw_begin() {
        return NkStyleProperty.ndraw_begin(this.address());
    }

    @Nullable
    @NativeType(value="nk_draw_end")
    public NkDrawEndCallback draw_end() {
        return NkStyleProperty.ndraw_end(this.address());
    }

    public NkStyleProperty normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleProperty.nnormal(this.address(), value);
        return this;
    }

    public NkStyleProperty normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public NkStyleProperty hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleProperty.nhover(this.address(), value);
        return this;
    }

    public NkStyleProperty hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.hover());
        return this;
    }

    public NkStyleProperty active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleProperty.nactive(this.address(), value);
        return this;
    }

    public NkStyleProperty active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.active());
        return this;
    }

    public NkStyleProperty border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleProperty.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleProperty border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleProperty label_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleProperty.nlabel_normal(this.address(), value);
        return this;
    }

    public NkStyleProperty label_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.label_normal());
        return this;
    }

    public NkStyleProperty label_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleProperty.nlabel_hover(this.address(), value);
        return this;
    }

    public NkStyleProperty label_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.label_hover());
        return this;
    }

    public NkStyleProperty label_active(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleProperty.nlabel_active(this.address(), value);
        return this;
    }

    public NkStyleProperty label_active(Consumer<NkColor> consumer) {
        consumer.accept(this.label_active());
        return this;
    }

    public NkStyleProperty sym_left(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleProperty.nsym_left(this.address(), value);
        return this;
    }

    public NkStyleProperty sym_right(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleProperty.nsym_right(this.address(), value);
        return this;
    }

    public NkStyleProperty border(float value) {
        NkStyleProperty.nborder(this.address(), value);
        return this;
    }

    public NkStyleProperty rounding(float value) {
        NkStyleProperty.nrounding(this.address(), value);
        return this;
    }

    public NkStyleProperty padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleProperty.npadding(this.address(), value);
        return this;
    }

    public NkStyleProperty padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleProperty edit(@NativeType(value="struct nk_style_edit") NkStyleEdit value) {
        NkStyleProperty.nedit(this.address(), value);
        return this;
    }

    public NkStyleProperty edit(Consumer<NkStyleEdit> consumer) {
        consumer.accept(this.edit());
        return this;
    }

    public NkStyleProperty inc_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleProperty.ninc_button(this.address(), value);
        return this;
    }

    public NkStyleProperty inc_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.inc_button());
        return this;
    }

    public NkStyleProperty dec_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleProperty.ndec_button(this.address(), value);
        return this;
    }

    public NkStyleProperty dec_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.dec_button());
        return this;
    }

    public NkStyleProperty userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkStyleProperty.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleProperty userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkStyleProperty draw_begin(@Nullable @NativeType(value="nk_draw_begin") NkDrawBeginCallbackI value) {
        NkStyleProperty.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleProperty draw_end(@Nullable @NativeType(value="nk_draw_end") NkDrawEndCallbackI value) {
        NkStyleProperty.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleProperty set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkColor label_normal, NkColor label_hover, NkColor label_active, int sym_left, int sym_right, float border, float rounding, NkVec2 padding, NkStyleEdit edit, NkStyleButton inc_button, NkStyleButton dec_button, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.label_normal(label_normal);
        this.label_hover(label_hover);
        this.label_active(label_active);
        this.sym_left(sym_left);
        this.sym_right(sym_right);
        this.border(border);
        this.rounding(rounding);
        this.padding(padding);
        this.edit(edit);
        this.inc_button(inc_button);
        this.dec_button(dec_button);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleProperty set(NkStyleProperty src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleProperty malloc() {
        return NkStyleProperty.wrap(NkStyleProperty.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkStyleProperty calloc() {
        return NkStyleProperty.wrap(NkStyleProperty.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkStyleProperty create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NkStyleProperty.wrap(NkStyleProperty.class, MemoryUtil.memAddress(container), container);
    }

    public static NkStyleProperty create(long address) {
        return NkStyleProperty.wrap(NkStyleProperty.class, address);
    }

    @Nullable
    public static NkStyleProperty createSafe(long address) {
        return address == 0L ? null : NkStyleProperty.wrap(NkStyleProperty.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleProperty.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NkStyleProperty.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleProperty.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleProperty.__create(capacity, SIZEOF);
        return NkStyleProperty.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NkStyleProperty.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkStyleProperty.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NkStyleProperty mallocStack() {
        return NkStyleProperty.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleProperty callocStack() {
        return NkStyleProperty.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleProperty mallocStack(MemoryStack stack) {
        return NkStyleProperty.malloc(stack);
    }

    @Deprecated
    public static NkStyleProperty callocStack(MemoryStack stack) {
        return NkStyleProperty.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleProperty.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleProperty.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleProperty.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleProperty.calloc(capacity, stack);
    }

    public static NkStyleProperty malloc(MemoryStack stack) {
        return NkStyleProperty.wrap(NkStyleProperty.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleProperty calloc(MemoryStack stack) {
        return NkStyleProperty.wrap(NkStyleProperty.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NkStyleProperty.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NkStyleProperty.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor nlabel_normal(long struct) {
        return NkColor.create(struct + (long)LABEL_NORMAL);
    }

    public static NkColor nlabel_hover(long struct) {
        return NkColor.create(struct + (long)LABEL_HOVER);
    }

    public static NkColor nlabel_active(long struct) {
        return NkColor.create(struct + (long)LABEL_ACTIVE);
    }

    public static int nsym_left(long struct) {
        return UNSAFE.getInt(null, struct + (long)SYM_LEFT);
    }

    public static int nsym_right(long struct) {
        return UNSAFE.getInt(null, struct + (long)SYM_RIGHT);
    }

    public static float nborder(long struct) {
        return UNSAFE.getFloat(null, struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ROUNDING);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkStyleEdit nedit(long struct) {
        return NkStyleEdit.create(struct + (long)EDIT);
    }

    public static NkStyleButton ninc_button(long struct) {
        return NkStyleButton.create(struct + (long)INC_BUTTON);
    }

    public static NkStyleButton ndec_button(long struct) {
        return NkStyleButton.create(struct + (long)DEC_BUTTON);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    @Nullable
    public static NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)DRAW_BEGIN));
    }

    @Nullable
    public static NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)DRAW_END));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HOVER, NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACTIVE, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nlabel_normal(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_NORMAL, NkColor.SIZEOF);
    }

    public static void nlabel_hover(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_HOVER, NkColor.SIZEOF);
    }

    public static void nlabel_active(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LABEL_ACTIVE, NkColor.SIZEOF);
    }

    public static void nsym_left(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SYM_LEFT, value);
    }

    public static void nsym_right(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SYM_RIGHT, value);
    }

    public static void nborder(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ROUNDING, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void nedit(long struct, NkStyleEdit value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EDIT, NkStyleEdit.SIZEOF);
    }

    public static void ninc_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INC_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void ndec_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEC_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, @Nullable NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_BEGIN, MemoryUtil.memAddressSafe(value));
    }

    public static void ndraw_end(long struct, @Nullable NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)DRAW_END, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = NkStyleProperty.__struct(NkStyleProperty.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProperty.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProperty.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleProperty.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleProperty.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleProperty.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleProperty.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleProperty.__member(4), NkStyleProperty.__member(4), NkStyleProperty.__member(4), NkStyleProperty.__member(4), NkStyleProperty.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleProperty.__member(NkStyleEdit.SIZEOF, NkStyleEdit.ALIGNOF), NkStyleProperty.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleProperty.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleProperty.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkStyleProperty.__member(POINTER_SIZE), NkStyleProperty.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        LABEL_NORMAL = layout.offsetof(4);
        LABEL_HOVER = layout.offsetof(5);
        LABEL_ACTIVE = layout.offsetof(6);
        SYM_LEFT = layout.offsetof(7);
        SYM_RIGHT = layout.offsetof(8);
        BORDER = layout.offsetof(9);
        ROUNDING = layout.offsetof(10);
        PADDING = layout.offsetof(11);
        EDIT = layout.offsetof(12);
        INC_BUTTON = layout.offsetof(13);
        DEC_BUTTON = layout.offsetof(14);
        USERDATA = layout.offsetof(15);
        DRAW_BEGIN = layout.offsetof(16);
        DRAW_END = layout.offsetof(17);
    }

    public static class Buffer
    extends StructBuffer<NkStyleProperty, Buffer>
    implements NativeResource {
        private static final NkStyleProperty ELEMENT_FACTORY = NkStyleProperty.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkStyleProperty getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem normal() {
            return NkStyleProperty.nnormal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem hover() {
            return NkStyleProperty.nhover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem active() {
            return NkStyleProperty.nactive(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleProperty.nborder_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor label_normal() {
            return NkStyleProperty.nlabel_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor label_hover() {
            return NkStyleProperty.nlabel_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor label_active() {
            return NkStyleProperty.nlabel_active(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int sym_left() {
            return NkStyleProperty.nsym_left(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int sym_right() {
            return NkStyleProperty.nsym_right(this.address());
        }

        public float border() {
            return NkStyleProperty.nborder(this.address());
        }

        public float rounding() {
            return NkStyleProperty.nrounding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleProperty.npadding(this.address());
        }

        @NativeType(value="struct nk_style_edit")
        public NkStyleEdit edit() {
            return NkStyleProperty.nedit(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton inc_button() {
            return NkStyleProperty.ninc_button(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton dec_button() {
            return NkStyleProperty.ndec_button(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkStyleProperty.nuserdata(this.address());
        }

        @Nullable
        @NativeType(value="nk_draw_begin")
        public NkDrawBeginCallback draw_begin() {
            return NkStyleProperty.ndraw_begin(this.address());
        }

        @Nullable
        @NativeType(value="nk_draw_end")
        public NkDrawEndCallback draw_end() {
            return NkStyleProperty.ndraw_end(this.address());
        }

        public Buffer normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleProperty.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.normal());
            return this;
        }

        public Buffer hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleProperty.nhover(this.address(), value);
            return this;
        }

        public Buffer hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.hover());
            return this;
        }

        public Buffer active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleProperty.nactive(this.address(), value);
            return this;
        }

        public Buffer active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.active());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleProperty.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer label_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleProperty.nlabel_normal(this.address(), value);
            return this;
        }

        public Buffer label_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.label_normal());
            return this;
        }

        public Buffer label_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleProperty.nlabel_hover(this.address(), value);
            return this;
        }

        public Buffer label_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.label_hover());
            return this;
        }

        public Buffer label_active(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleProperty.nlabel_active(this.address(), value);
            return this;
        }

        public Buffer label_active(Consumer<NkColor> consumer) {
            consumer.accept(this.label_active());
            return this;
        }

        public Buffer sym_left(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleProperty.nsym_left(this.address(), value);
            return this;
        }

        public Buffer sym_right(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleProperty.nsym_right(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleProperty.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleProperty.nrounding(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleProperty.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer edit(@NativeType(value="struct nk_style_edit") NkStyleEdit value) {
            NkStyleProperty.nedit(this.address(), value);
            return this;
        }

        public Buffer edit(Consumer<NkStyleEdit> consumer) {
            consumer.accept(this.edit());
            return this;
        }

        public Buffer inc_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleProperty.ninc_button(this.address(), value);
            return this;
        }

        public Buffer inc_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.inc_button());
            return this;
        }

        public Buffer dec_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleProperty.ndec_button(this.address(), value);
            return this;
        }

        public Buffer dec_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.dec_button());
            return this;
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkStyleProperty.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer draw_begin(@Nullable @NativeType(value="nk_draw_begin") NkDrawBeginCallbackI value) {
            NkStyleProperty.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(@Nullable @NativeType(value="nk_draw_end") NkDrawEndCallbackI value) {
            NkStyleProperty.ndraw_end(this.address(), value);
            return this;
        }
    }
}

