/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_tab")
public class NkStyleTab
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACKGROUND;
    public static final int BORDER_COLOR;
    public static final int TEXT;
    public static final int TAB_MAXIMIZE_BUTTON;
    public static final int TAB_MINIMIZE_BUTTON;
    public static final int NODE_MAXIMIZE_BUTTON;
    public static final int NODE_MINIMIZE_BUTTON;
    public static final int SYM_MINIMIZE;
    public static final int SYM_MAXIMIZE;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int INDENT;
    public static final int PADDING;
    public static final int SPACING;

    public NkStyleTab(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkStyleTab.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem background() {
        return NkStyleTab.nbackground(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleTab.nborder_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text() {
        return NkStyleTab.ntext(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton tab_maximize_button() {
        return NkStyleTab.ntab_maximize_button(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton tab_minimize_button() {
        return NkStyleTab.ntab_minimize_button(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton node_maximize_button() {
        return NkStyleTab.nnode_maximize_button(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton node_minimize_button() {
        return NkStyleTab.nnode_minimize_button(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int sym_minimize() {
        return NkStyleTab.nsym_minimize(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int sym_maximize() {
        return NkStyleTab.nsym_maximize(this.address());
    }

    public float border() {
        return NkStyleTab.nborder(this.address());
    }

    public float rounding() {
        return NkStyleTab.nrounding(this.address());
    }

    public float indent() {
        return NkStyleTab.nindent(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleTab.npadding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 spacing() {
        return NkStyleTab.nspacing(this.address());
    }

    public NkStyleTab background(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleTab.nbackground(this.address(), value);
        return this;
    }

    public NkStyleTab background(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.background());
        return this;
    }

    public NkStyleTab border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleTab.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleTab border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleTab text(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleTab.ntext(this.address(), value);
        return this;
    }

    public NkStyleTab text(Consumer<NkColor> consumer) {
        consumer.accept(this.text());
        return this;
    }

    public NkStyleTab tab_maximize_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleTab.ntab_maximize_button(this.address(), value);
        return this;
    }

    public NkStyleTab tab_maximize_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.tab_maximize_button());
        return this;
    }

    public NkStyleTab tab_minimize_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleTab.ntab_minimize_button(this.address(), value);
        return this;
    }

    public NkStyleTab tab_minimize_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.tab_minimize_button());
        return this;
    }

    public NkStyleTab node_maximize_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleTab.nnode_maximize_button(this.address(), value);
        return this;
    }

    public NkStyleTab node_maximize_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.node_maximize_button());
        return this;
    }

    public NkStyleTab node_minimize_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleTab.nnode_minimize_button(this.address(), value);
        return this;
    }

    public NkStyleTab node_minimize_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.node_minimize_button());
        return this;
    }

    public NkStyleTab sym_minimize(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleTab.nsym_minimize(this.address(), value);
        return this;
    }

    public NkStyleTab sym_maximize(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleTab.nsym_maximize(this.address(), value);
        return this;
    }

    public NkStyleTab border(float value) {
        NkStyleTab.nborder(this.address(), value);
        return this;
    }

    public NkStyleTab rounding(float value) {
        NkStyleTab.nrounding(this.address(), value);
        return this;
    }

    public NkStyleTab indent(float value) {
        NkStyleTab.nindent(this.address(), value);
        return this;
    }

    public NkStyleTab padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleTab.npadding(this.address(), value);
        return this;
    }

    public NkStyleTab padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleTab spacing(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleTab.nspacing(this.address(), value);
        return this;
    }

    public NkStyleTab spacing(Consumer<NkVec2> consumer) {
        consumer.accept(this.spacing());
        return this;
    }

    public NkStyleTab set(NkStyleItem background, NkColor border_color, NkColor text, NkStyleButton tab_maximize_button, NkStyleButton tab_minimize_button, NkStyleButton node_maximize_button, NkStyleButton node_minimize_button, int sym_minimize, int sym_maximize, float border, float rounding, float indent, NkVec2 padding, NkVec2 spacing) {
        this.background(background);
        this.border_color(border_color);
        this.text(text);
        this.tab_maximize_button(tab_maximize_button);
        this.tab_minimize_button(tab_minimize_button);
        this.node_maximize_button(node_maximize_button);
        this.node_minimize_button(node_minimize_button);
        this.sym_minimize(sym_minimize);
        this.sym_maximize(sym_maximize);
        this.border(border);
        this.rounding(rounding);
        this.indent(indent);
        this.padding(padding);
        this.spacing(spacing);
        return this;
    }

    public NkStyleTab set(NkStyleTab src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleTab malloc() {
        return NkStyleTab.wrap(NkStyleTab.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkStyleTab calloc() {
        return NkStyleTab.wrap(NkStyleTab.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkStyleTab create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NkStyleTab.wrap(NkStyleTab.class, MemoryUtil.memAddress(container), container);
    }

    public static NkStyleTab create(long address) {
        return NkStyleTab.wrap(NkStyleTab.class, address);
    }

    @Nullable
    public static NkStyleTab createSafe(long address) {
        return address == 0L ? null : NkStyleTab.wrap(NkStyleTab.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleTab.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NkStyleTab.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleTab.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleTab.__create(capacity, SIZEOF);
        return NkStyleTab.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NkStyleTab.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkStyleTab.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NkStyleTab mallocStack() {
        return NkStyleTab.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleTab callocStack() {
        return NkStyleTab.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleTab mallocStack(MemoryStack stack) {
        return NkStyleTab.malloc(stack);
    }

    @Deprecated
    public static NkStyleTab callocStack(MemoryStack stack) {
        return NkStyleTab.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleTab.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleTab.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleTab.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleTab.calloc(capacity, stack);
    }

    public static NkStyleTab malloc(MemoryStack stack) {
        return NkStyleTab.wrap(NkStyleTab.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleTab calloc(MemoryStack stack) {
        return NkStyleTab.wrap(NkStyleTab.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NkStyleTab.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NkStyleTab.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nbackground(long struct) {
        return NkStyleItem.create(struct + (long)BACKGROUND);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor ntext(long struct) {
        return NkColor.create(struct + (long)TEXT);
    }

    public static NkStyleButton ntab_maximize_button(long struct) {
        return NkStyleButton.create(struct + (long)TAB_MAXIMIZE_BUTTON);
    }

    public static NkStyleButton ntab_minimize_button(long struct) {
        return NkStyleButton.create(struct + (long)TAB_MINIMIZE_BUTTON);
    }

    public static NkStyleButton nnode_maximize_button(long struct) {
        return NkStyleButton.create(struct + (long)NODE_MAXIMIZE_BUTTON);
    }

    public static NkStyleButton nnode_minimize_button(long struct) {
        return NkStyleButton.create(struct + (long)NODE_MINIMIZE_BUTTON);
    }

    public static int nsym_minimize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SYM_MINIMIZE);
    }

    public static int nsym_maximize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SYM_MAXIMIZE);
    }

    public static float nborder(long struct) {
        return UNSAFE.getFloat(null, struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ROUNDING);
    }

    public static float nindent(long struct) {
        return UNSAFE.getFloat(null, struct + (long)INDENT);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 nspacing(long struct) {
        return NkVec2.create(struct + (long)SPACING);
    }

    public static void nbackground(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BACKGROUND, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void ntext(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT, NkColor.SIZEOF);
    }

    public static void ntab_maximize_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TAB_MAXIMIZE_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void ntab_minimize_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TAB_MINIMIZE_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void nnode_maximize_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NODE_MAXIMIZE_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void nnode_minimize_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NODE_MINIMIZE_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void nsym_minimize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SYM_MINIMIZE, value);
    }

    public static void nsym_maximize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SYM_MAXIMIZE, value);
    }

    public static void nborder(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ROUNDING, value);
    }

    public static void nindent(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)INDENT, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void nspacing(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SPACING, NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleTab.__struct(NkStyleTab.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleTab.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleTab.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleTab.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleTab.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleTab.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleTab.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyleTab.__member(4), NkStyleTab.__member(4), NkStyleTab.__member(4), NkStyleTab.__member(4), NkStyleTab.__member(4), NkStyleTab.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleTab.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACKGROUND = layout.offsetof(0);
        BORDER_COLOR = layout.offsetof(1);
        TEXT = layout.offsetof(2);
        TAB_MAXIMIZE_BUTTON = layout.offsetof(3);
        TAB_MINIMIZE_BUTTON = layout.offsetof(4);
        NODE_MAXIMIZE_BUTTON = layout.offsetof(5);
        NODE_MINIMIZE_BUTTON = layout.offsetof(6);
        SYM_MINIMIZE = layout.offsetof(7);
        SYM_MAXIMIZE = layout.offsetof(8);
        BORDER = layout.offsetof(9);
        ROUNDING = layout.offsetof(10);
        INDENT = layout.offsetof(11);
        PADDING = layout.offsetof(12);
        SPACING = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<NkStyleTab, Buffer>
    implements NativeResource {
        private static final NkStyleTab ELEMENT_FACTORY = NkStyleTab.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkStyleTab getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem background() {
            return NkStyleTab.nbackground(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleTab.nborder_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text() {
            return NkStyleTab.ntext(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton tab_maximize_button() {
            return NkStyleTab.ntab_maximize_button(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton tab_minimize_button() {
            return NkStyleTab.ntab_minimize_button(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton node_maximize_button() {
            return NkStyleTab.nnode_maximize_button(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton node_minimize_button() {
            return NkStyleTab.nnode_minimize_button(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int sym_minimize() {
            return NkStyleTab.nsym_minimize(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int sym_maximize() {
            return NkStyleTab.nsym_maximize(this.address());
        }

        public float border() {
            return NkStyleTab.nborder(this.address());
        }

        public float rounding() {
            return NkStyleTab.nrounding(this.address());
        }

        public float indent() {
            return NkStyleTab.nindent(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleTab.npadding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 spacing() {
            return NkStyleTab.nspacing(this.address());
        }

        public Buffer background(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleTab.nbackground(this.address(), value);
            return this;
        }

        public Buffer background(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.background());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleTab.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer text(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleTab.ntext(this.address(), value);
            return this;
        }

        public Buffer text(Consumer<NkColor> consumer) {
            consumer.accept(this.text());
            return this;
        }

        public Buffer tab_maximize_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleTab.ntab_maximize_button(this.address(), value);
            return this;
        }

        public Buffer tab_maximize_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.tab_maximize_button());
            return this;
        }

        public Buffer tab_minimize_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleTab.ntab_minimize_button(this.address(), value);
            return this;
        }

        public Buffer tab_minimize_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.tab_minimize_button());
            return this;
        }

        public Buffer node_maximize_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleTab.nnode_maximize_button(this.address(), value);
            return this;
        }

        public Buffer node_maximize_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.node_maximize_button());
            return this;
        }

        public Buffer node_minimize_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleTab.nnode_minimize_button(this.address(), value);
            return this;
        }

        public Buffer node_minimize_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.node_minimize_button());
            return this;
        }

        public Buffer sym_minimize(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleTab.nsym_minimize(this.address(), value);
            return this;
        }

        public Buffer sym_maximize(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleTab.nsym_maximize(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleTab.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleTab.nrounding(this.address(), value);
            return this;
        }

        public Buffer indent(float value) {
            NkStyleTab.nindent(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleTab.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer spacing(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleTab.nspacing(this.address(), value);
            return this;
        }

        public Buffer spacing(Consumer<NkVec2> consumer) {
            consumer.accept(this.spacing());
            return this;
        }
    }
}

