/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HiddenAreaMesh_t")
public class HiddenAreaMesh
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PVERTEXDATA;
    public static final int UNTRIANGLECOUNT;

    public HiddenAreaMesh(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), HiddenAreaMesh.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="HmdVector2_t *")
    public HmdVector2.Buffer pVertexData() {
        return HiddenAreaMesh.npVertexData(this.address());
    }

    @NativeType(value="uint32_t")
    public int unTriangleCount() {
        return HiddenAreaMesh.nunTriangleCount(this.address());
    }

    public static HiddenAreaMesh malloc() {
        return HiddenAreaMesh.wrap(HiddenAreaMesh.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HiddenAreaMesh calloc() {
        return HiddenAreaMesh.wrap(HiddenAreaMesh.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HiddenAreaMesh create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return HiddenAreaMesh.wrap(HiddenAreaMesh.class, MemoryUtil.memAddress(container), container);
    }

    public static HiddenAreaMesh create(long address) {
        return HiddenAreaMesh.wrap(HiddenAreaMesh.class, address);
    }

    @Nullable
    public static HiddenAreaMesh createSafe(long address) {
        return address == 0L ? null : HiddenAreaMesh.wrap(HiddenAreaMesh.class, address);
    }

    public static Buffer malloc(int capacity) {
        return HiddenAreaMesh.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(HiddenAreaMesh.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HiddenAreaMesh.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HiddenAreaMesh.__create(capacity, SIZEOF);
        return HiddenAreaMesh.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return HiddenAreaMesh.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HiddenAreaMesh.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static HiddenAreaMesh mallocStack() {
        return HiddenAreaMesh.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HiddenAreaMesh callocStack() {
        return HiddenAreaMesh.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HiddenAreaMesh mallocStack(MemoryStack stack) {
        return HiddenAreaMesh.malloc(stack);
    }

    @Deprecated
    public static HiddenAreaMesh callocStack(MemoryStack stack) {
        return HiddenAreaMesh.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HiddenAreaMesh.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HiddenAreaMesh.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HiddenAreaMesh.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HiddenAreaMesh.calloc(capacity, stack);
    }

    public static HiddenAreaMesh malloc(MemoryStack stack) {
        return HiddenAreaMesh.wrap(HiddenAreaMesh.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HiddenAreaMesh calloc(MemoryStack stack) {
        return HiddenAreaMesh.wrap(HiddenAreaMesh.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return HiddenAreaMesh.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return HiddenAreaMesh.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    @Nullable
    public static HmdVector2.Buffer npVertexData(long struct) {
        return HmdVector2.createSafe(MemoryUtil.memGetAddress(struct + (long)PVERTEXDATA), HiddenAreaMesh.nunTriangleCount(struct));
    }

    public static int nunTriangleCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNTRIANGLECOUNT);
    }

    static {
        Struct.Layout layout = HiddenAreaMesh.__struct(HiddenAreaMesh.__member(POINTER_SIZE), HiddenAreaMesh.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PVERTEXDATA = layout.offsetof(0);
        UNTRIANGLECOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<HiddenAreaMesh, Buffer>
    implements NativeResource {
        private static final HiddenAreaMesh ELEMENT_FACTORY = HiddenAreaMesh.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected HiddenAreaMesh getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="HmdVector2_t *")
        public HmdVector2.Buffer pVertexData() {
            return HiddenAreaMesh.npVertexData(this.address());
        }

        @NativeType(value="uint32_t")
        public int unTriangleCount() {
            return HiddenAreaMesh.nunTriangleCount(this.address());
        }
    }
}

