/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdColor_t")
public class HmdColor
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    public HmdColor(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), HmdColor.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return HmdColor.nr(this.address());
    }

    public float g() {
        return HmdColor.ng(this.address());
    }

    public float b() {
        return HmdColor.nb(this.address());
    }

    public float a() {
        return HmdColor.na(this.address());
    }

    public HmdColor r(float value) {
        HmdColor.nr(this.address(), value);
        return this;
    }

    public HmdColor g(float value) {
        HmdColor.ng(this.address(), value);
        return this;
    }

    public HmdColor b(float value) {
        HmdColor.nb(this.address(), value);
        return this;
    }

    public HmdColor a(float value) {
        HmdColor.na(this.address(), value);
        return this;
    }

    public HmdColor set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public HmdColor set(HmdColor src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdColor malloc() {
        return HmdColor.wrap(HmdColor.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdColor calloc() {
        return HmdColor.wrap(HmdColor.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdColor create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return HmdColor.wrap(HmdColor.class, MemoryUtil.memAddress(container), container);
    }

    public static HmdColor create(long address) {
        return HmdColor.wrap(HmdColor.class, address);
    }

    @Nullable
    public static HmdColor createSafe(long address) {
        return address == 0L ? null : HmdColor.wrap(HmdColor.class, address);
    }

    public static Buffer malloc(int capacity) {
        return HmdColor.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(HmdColor.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdColor.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdColor.__create(capacity, SIZEOF);
        return HmdColor.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return HmdColor.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdColor.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static HmdColor mallocStack() {
        return HmdColor.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdColor callocStack() {
        return HmdColor.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdColor mallocStack(MemoryStack stack) {
        return HmdColor.malloc(stack);
    }

    @Deprecated
    public static HmdColor callocStack(MemoryStack stack) {
        return HmdColor.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdColor.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdColor.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdColor.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdColor.calloc(capacity, stack);
    }

    public static HmdColor malloc(MemoryStack stack) {
        return HmdColor.wrap(HmdColor.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdColor calloc(MemoryStack stack) {
        return HmdColor.wrap(HmdColor.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return HmdColor.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return HmdColor.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)R);
    }

    public static float ng(long struct) {
        return UNSAFE.getFloat(null, struct + (long)G);
    }

    public static float nb(long struct) {
        return UNSAFE.getFloat(null, struct + (long)B);
    }

    public static float na(long struct) {
        return UNSAFE.getFloat(null, struct + (long)A);
    }

    public static void nr(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)B, value);
    }

    public static void na(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)A, value);
    }

    static {
        Struct.Layout layout = HmdColor.__struct(HmdColor.__member(4), HmdColor.__member(4), HmdColor.__member(4), HmdColor.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<HmdColor, Buffer>
    implements NativeResource {
        private static final HmdColor ELEMENT_FACTORY = HmdColor.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected HmdColor getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float r() {
            return HmdColor.nr(this.address());
        }

        public float g() {
            return HmdColor.ng(this.address());
        }

        public float b() {
            return HmdColor.nb(this.address());
        }

        public float a() {
            return HmdColor.na(this.address());
        }

        public Buffer r(float value) {
            HmdColor.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            HmdColor.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            HmdColor.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            HmdColor.na(this.address(), value);
            return this;
        }
    }
}

