/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdMatrix44_t")
public class HmdMatrix44
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M;

    public HmdMatrix44(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), HmdMatrix44.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[16]")
    public FloatBuffer m() {
        return HmdMatrix44.nm(this.address());
    }

    public float m(int index) {
        return HmdMatrix44.nm(this.address(), index);
    }

    public HmdMatrix44 m(@NativeType(value="float[16]") FloatBuffer value) {
        HmdMatrix44.nm(this.address(), value);
        return this;
    }

    public HmdMatrix44 m(int index, float value) {
        HmdMatrix44.nm(this.address(), index, value);
        return this;
    }

    public HmdMatrix44 set(HmdMatrix44 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdMatrix44 malloc() {
        return HmdMatrix44.wrap(HmdMatrix44.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdMatrix44 calloc() {
        return HmdMatrix44.wrap(HmdMatrix44.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdMatrix44 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return HmdMatrix44.wrap(HmdMatrix44.class, MemoryUtil.memAddress(container), container);
    }

    public static HmdMatrix44 create(long address) {
        return HmdMatrix44.wrap(HmdMatrix44.class, address);
    }

    @Nullable
    public static HmdMatrix44 createSafe(long address) {
        return address == 0L ? null : HmdMatrix44.wrap(HmdMatrix44.class, address);
    }

    public static Buffer malloc(int capacity) {
        return HmdMatrix44.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(HmdMatrix44.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdMatrix44.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdMatrix44.__create(capacity, SIZEOF);
        return HmdMatrix44.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return HmdMatrix44.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdMatrix44.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static HmdMatrix44 mallocStack() {
        return HmdMatrix44.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdMatrix44 callocStack() {
        return HmdMatrix44.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdMatrix44 mallocStack(MemoryStack stack) {
        return HmdMatrix44.malloc(stack);
    }

    @Deprecated
    public static HmdMatrix44 callocStack(MemoryStack stack) {
        return HmdMatrix44.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdMatrix44.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdMatrix44.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdMatrix44.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdMatrix44.calloc(capacity, stack);
    }

    public static HmdMatrix44 malloc(MemoryStack stack) {
        return HmdMatrix44.wrap(HmdMatrix44.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdMatrix44 calloc(MemoryStack stack) {
        return HmdMatrix44.wrap(HmdMatrix44.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return HmdMatrix44.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return HmdMatrix44.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nm(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)M, 16);
    }

    public static float nm(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)M + Checks.check(index, 16) * 4L);
    }

    public static void nm(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)M, value.remaining() * 4);
    }

    public static void nm(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)M + Checks.check(index, 16) * 4L, value);
    }

    static {
        Struct.Layout layout = HmdMatrix44.__struct(HmdMatrix44.__array(4, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdMatrix44, Buffer>
    implements NativeResource {
        private static final HmdMatrix44 ELEMENT_FACTORY = HmdMatrix44.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected HmdMatrix44 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[16]")
        public FloatBuffer m() {
            return HmdMatrix44.nm(this.address());
        }

        public float m(int index) {
            return HmdMatrix44.nm(this.address(), index);
        }

        public Buffer m(@NativeType(value="float[16]") FloatBuffer value) {
            HmdMatrix44.nm(this.address(), value);
            return this;
        }

        public Buffer m(int index, float value) {
            HmdMatrix44.nm(this.address(), index, value);
            return this;
        }
    }
}

