/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdQuaternionf_t")
public class HmdQuaternionf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int X;
    public static final int Y;
    public static final int Z;

    public HmdQuaternionf(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), HmdQuaternionf.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float w() {
        return HmdQuaternionf.nw(this.address());
    }

    public float x() {
        return HmdQuaternionf.nx(this.address());
    }

    public float y() {
        return HmdQuaternionf.ny(this.address());
    }

    public float z() {
        return HmdQuaternionf.nz(this.address());
    }

    public HmdQuaternionf w(float value) {
        HmdQuaternionf.nw(this.address(), value);
        return this;
    }

    public HmdQuaternionf x(float value) {
        HmdQuaternionf.nx(this.address(), value);
        return this;
    }

    public HmdQuaternionf y(float value) {
        HmdQuaternionf.ny(this.address(), value);
        return this;
    }

    public HmdQuaternionf z(float value) {
        HmdQuaternionf.nz(this.address(), value);
        return this;
    }

    public HmdQuaternionf set(float w, float x, float y, float z) {
        this.w(w);
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public HmdQuaternionf set(HmdQuaternionf src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdQuaternionf malloc() {
        return HmdQuaternionf.wrap(HmdQuaternionf.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdQuaternionf calloc() {
        return HmdQuaternionf.wrap(HmdQuaternionf.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdQuaternionf create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return HmdQuaternionf.wrap(HmdQuaternionf.class, MemoryUtil.memAddress(container), container);
    }

    public static HmdQuaternionf create(long address) {
        return HmdQuaternionf.wrap(HmdQuaternionf.class, address);
    }

    @Nullable
    public static HmdQuaternionf createSafe(long address) {
        return address == 0L ? null : HmdQuaternionf.wrap(HmdQuaternionf.class, address);
    }

    public static Buffer malloc(int capacity) {
        return HmdQuaternionf.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(HmdQuaternionf.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdQuaternionf.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdQuaternionf.__create(capacity, SIZEOF);
        return HmdQuaternionf.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return HmdQuaternionf.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdQuaternionf.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static HmdQuaternionf mallocStack() {
        return HmdQuaternionf.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdQuaternionf callocStack() {
        return HmdQuaternionf.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdQuaternionf mallocStack(MemoryStack stack) {
        return HmdQuaternionf.malloc(stack);
    }

    @Deprecated
    public static HmdQuaternionf callocStack(MemoryStack stack) {
        return HmdQuaternionf.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdQuaternionf.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdQuaternionf.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdQuaternionf.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdQuaternionf.calloc(capacity, stack);
    }

    public static HmdQuaternionf malloc(MemoryStack stack) {
        return HmdQuaternionf.wrap(HmdQuaternionf.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdQuaternionf calloc(MemoryStack stack) {
        return HmdQuaternionf.wrap(HmdQuaternionf.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return HmdQuaternionf.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return HmdQuaternionf.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nz(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Z);
    }

    public static void nw(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)W, value);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = HmdQuaternionf.__struct(HmdQuaternionf.__member(4), HmdQuaternionf.__member(4), HmdQuaternionf.__member(4), HmdQuaternionf.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        Z = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<HmdQuaternionf, Buffer>
    implements NativeResource {
        private static final HmdQuaternionf ELEMENT_FACTORY = HmdQuaternionf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected HmdQuaternionf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float w() {
            return HmdQuaternionf.nw(this.address());
        }

        public float x() {
            return HmdQuaternionf.nx(this.address());
        }

        public float y() {
            return HmdQuaternionf.ny(this.address());
        }

        public float z() {
            return HmdQuaternionf.nz(this.address());
        }

        public Buffer w(float value) {
            HmdQuaternionf.nw(this.address(), value);
            return this;
        }

        public Buffer x(float value) {
            HmdQuaternionf.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            HmdQuaternionf.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            HmdQuaternionf.nz(this.address(), value);
            return this;
        }
    }
}

