/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdVector4_t")
public class HmdVector4
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int V;

    public HmdVector4(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), HmdVector4.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[4]")
    public FloatBuffer v() {
        return HmdVector4.nv(this.address());
    }

    public float v(int index) {
        return HmdVector4.nv(this.address(), index);
    }

    public HmdVector4 v(@NativeType(value="float[4]") FloatBuffer value) {
        HmdVector4.nv(this.address(), value);
        return this;
    }

    public HmdVector4 v(int index, float value) {
        HmdVector4.nv(this.address(), index, value);
        return this;
    }

    public HmdVector4 set(HmdVector4 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdVector4 malloc() {
        return HmdVector4.wrap(HmdVector4.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdVector4 calloc() {
        return HmdVector4.wrap(HmdVector4.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdVector4 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return HmdVector4.wrap(HmdVector4.class, MemoryUtil.memAddress(container), container);
    }

    public static HmdVector4 create(long address) {
        return HmdVector4.wrap(HmdVector4.class, address);
    }

    @Nullable
    public static HmdVector4 createSafe(long address) {
        return address == 0L ? null : HmdVector4.wrap(HmdVector4.class, address);
    }

    public static Buffer malloc(int capacity) {
        return HmdVector4.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(HmdVector4.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdVector4.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdVector4.__create(capacity, SIZEOF);
        return HmdVector4.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return HmdVector4.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdVector4.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static HmdVector4 mallocStack() {
        return HmdVector4.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector4 callocStack() {
        return HmdVector4.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector4 mallocStack(MemoryStack stack) {
        return HmdVector4.malloc(stack);
    }

    @Deprecated
    public static HmdVector4 callocStack(MemoryStack stack) {
        return HmdVector4.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdVector4.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdVector4.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdVector4.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdVector4.calloc(capacity, stack);
    }

    public static HmdVector4 malloc(MemoryStack stack) {
        return HmdVector4.wrap(HmdVector4.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdVector4 calloc(MemoryStack stack) {
        return HmdVector4.wrap(HmdVector4.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return HmdVector4.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return HmdVector4.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nv(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)V, 4);
    }

    public static float nv(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)V + Checks.check(index, 4) * 4L);
    }

    public static void nv(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)V, value.remaining() * 4);
    }

    public static void nv(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)V + Checks.check(index, 4) * 4L, value);
    }

    static {
        Struct.Layout layout = HmdVector4.__struct(HmdVector4.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        V = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdVector4, Buffer>
    implements NativeResource {
        private static final HmdVector4 ELEMENT_FACTORY = HmdVector4.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected HmdVector4 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[4]")
        public FloatBuffer v() {
            return HmdVector4.nv(this.address());
        }

        public float v(int index) {
            return HmdVector4.nv(this.address(), index);
        }

        public Buffer v(@NativeType(value="float[4]") FloatBuffer value) {
            HmdVector4.nv(this.address(), value);
            return this;
        }

        public Buffer v(int index, float value) {
            HmdVector4.nv(this.address(), index, value);
            return this;
        }
    }
}

