/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.HmdVector3d;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ImuSample_t")
public class ImuSample
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FSAMPLETIME;
    public static final int VACCEL;
    public static final int VGYRO;
    public static final int UNOFFSCALEFLAGS;

    public ImuSample(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ImuSample.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double fSampleTime() {
        return ImuSample.nfSampleTime(this.address());
    }

    @NativeType(value="HmdVector3d_t")
    public HmdVector3d vAccel() {
        return ImuSample.nvAccel(this.address());
    }

    @NativeType(value="HmdVector3d_t")
    public HmdVector3d vGyro() {
        return ImuSample.nvGyro(this.address());
    }

    @NativeType(value="uint32_t")
    public int unOffScaleFlags() {
        return ImuSample.nunOffScaleFlags(this.address());
    }

    public static ImuSample create(long address) {
        return ImuSample.wrap(ImuSample.class, address);
    }

    @Nullable
    public static ImuSample createSafe(long address) {
        return address == 0L ? null : ImuSample.wrap(ImuSample.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return ImuSample.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ImuSample.wrap(Buffer.class, address, capacity);
    }

    public static double nfSampleTime(long struct) {
        return UNSAFE.getDouble(null, struct + (long)FSAMPLETIME);
    }

    public static HmdVector3d nvAccel(long struct) {
        return HmdVector3d.create(struct + (long)VACCEL);
    }

    public static HmdVector3d nvGyro(long struct) {
        return HmdVector3d.create(struct + (long)VGYRO);
    }

    public static int nunOffScaleFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNOFFSCALEFLAGS);
    }

    static {
        Struct.Layout layout = ImuSample.__struct(ImuSample.__member(8), ImuSample.__member(HmdVector3d.SIZEOF, HmdVector3d.ALIGNOF), ImuSample.__member(HmdVector3d.SIZEOF, HmdVector3d.ALIGNOF), ImuSample.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FSAMPLETIME = layout.offsetof(0);
        VACCEL = layout.offsetof(1);
        VGYRO = layout.offsetof(2);
        UNOFFSCALEFLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<ImuSample, Buffer> {
        private static final ImuSample ELEMENT_FACTORY = ImuSample.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ImuSample getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double fSampleTime() {
            return ImuSample.nfSampleTime(this.address());
        }

        @NativeType(value="HmdVector3d_t")
        public HmdVector3d vAccel() {
            return ImuSample.nvAccel(this.address());
        }

        @NativeType(value="HmdVector3d_t")
        public HmdVector3d vGyro() {
            return ImuSample.nvGyro(this.address());
        }

        @NativeType(value="uint32_t")
        public int unOffScaleFlags() {
            return ImuSample.nunOffScaleFlags(this.address());
        }
    }
}

