/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputDigitalActionData_t")
public class InputDigitalActionData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;
    public static final int BSTATE;
    public static final int BCHANGED;
    public static final int FUPDATETIME;

    public InputDigitalActionData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), InputDigitalActionData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputDigitalActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputDigitalActionData.nactiveOrigin(this.address());
    }

    @NativeType(value="bool")
    public boolean bState() {
        return InputDigitalActionData.nbState(this.address());
    }

    @NativeType(value="bool")
    public boolean bChanged() {
        return InputDigitalActionData.nbChanged(this.address());
    }

    public float fUpdateTime() {
        return InputDigitalActionData.nfUpdateTime(this.address());
    }

    public static InputDigitalActionData malloc() {
        return InputDigitalActionData.wrap(InputDigitalActionData.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static InputDigitalActionData calloc() {
        return InputDigitalActionData.wrap(InputDigitalActionData.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static InputDigitalActionData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return InputDigitalActionData.wrap(InputDigitalActionData.class, MemoryUtil.memAddress(container), container);
    }

    public static InputDigitalActionData create(long address) {
        return InputDigitalActionData.wrap(InputDigitalActionData.class, address);
    }

    @Nullable
    public static InputDigitalActionData createSafe(long address) {
        return address == 0L ? null : InputDigitalActionData.wrap(InputDigitalActionData.class, address);
    }

    public static Buffer malloc(int capacity) {
        return InputDigitalActionData.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(InputDigitalActionData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return InputDigitalActionData.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputDigitalActionData.__create(capacity, SIZEOF);
        return InputDigitalActionData.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return InputDigitalActionData.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : InputDigitalActionData.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static InputDigitalActionData mallocStack() {
        return InputDigitalActionData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputDigitalActionData callocStack() {
        return InputDigitalActionData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputDigitalActionData mallocStack(MemoryStack stack) {
        return InputDigitalActionData.malloc(stack);
    }

    @Deprecated
    public static InputDigitalActionData callocStack(MemoryStack stack) {
        return InputDigitalActionData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputDigitalActionData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputDigitalActionData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputDigitalActionData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputDigitalActionData.calloc(capacity, stack);
    }

    public static InputDigitalActionData malloc(MemoryStack stack) {
        return InputDigitalActionData.wrap(InputDigitalActionData.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputDigitalActionData calloc(MemoryStack stack) {
        return InputDigitalActionData.wrap(InputDigitalActionData.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return InputDigitalActionData.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return InputDigitalActionData.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbActive(long struct) {
        return UNSAFE.getByte(null, struct + (long)BACTIVE) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return UNSAFE.getLong(null, struct + (long)ACTIVEORIGIN);
    }

    public static boolean nbState(long struct) {
        return UNSAFE.getByte(null, struct + (long)BSTATE) != 0;
    }

    public static boolean nbChanged(long struct) {
        return UNSAFE.getByte(null, struct + (long)BCHANGED) != 0;
    }

    public static float nfUpdateTime(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FUPDATETIME);
    }

    static {
        Struct.Layout layout = InputDigitalActionData.__struct(InputDigitalActionData.__member(1), InputDigitalActionData.__member(8), InputDigitalActionData.__member(1), InputDigitalActionData.__member(1), InputDigitalActionData.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
        BSTATE = layout.offsetof(2);
        BCHANGED = layout.offsetof(3);
        FUPDATETIME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<InputDigitalActionData, Buffer>
    implements NativeResource {
        private static final InputDigitalActionData ELEMENT_FACTORY = InputDigitalActionData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected InputDigitalActionData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputDigitalActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputDigitalActionData.nactiveOrigin(this.address());
        }

        @NativeType(value="bool")
        public boolean bState() {
            return InputDigitalActionData.nbState(this.address());
        }

        @NativeType(value="bool")
        public boolean bChanged() {
            return InputDigitalActionData.nbChanged(this.address());
        }

        public float fUpdateTime() {
            return InputDigitalActionData.nfUpdateTime(this.address());
        }
    }
}

