/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputOriginInfo_t")
public class InputOriginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEPATH;
    public static final int TRACKEDDEVICEINDEX;
    public static final int RCHRENDERMODELCOMPONENTNAME;

    public InputOriginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), InputOriginInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VRInputValueHandle_t")
    public long devicePath() {
        return InputOriginInfo.ndevicePath(this.address());
    }

    @NativeType(value="TrackedDeviceIndex_t")
    public int trackedDeviceIndex() {
        return InputOriginInfo.ntrackedDeviceIndex(this.address());
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchRenderModelComponentName() {
        return InputOriginInfo.nrchRenderModelComponentName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchRenderModelComponentNameString() {
        return InputOriginInfo.nrchRenderModelComponentNameString(this.address());
    }

    public static InputOriginInfo malloc() {
        return InputOriginInfo.wrap(InputOriginInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static InputOriginInfo calloc() {
        return InputOriginInfo.wrap(InputOriginInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static InputOriginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return InputOriginInfo.wrap(InputOriginInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static InputOriginInfo create(long address) {
        return InputOriginInfo.wrap(InputOriginInfo.class, address);
    }

    @Nullable
    public static InputOriginInfo createSafe(long address) {
        return address == 0L ? null : InputOriginInfo.wrap(InputOriginInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return InputOriginInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(InputOriginInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return InputOriginInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputOriginInfo.__create(capacity, SIZEOF);
        return InputOriginInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return InputOriginInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : InputOriginInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static InputOriginInfo mallocStack() {
        return InputOriginInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputOriginInfo callocStack() {
        return InputOriginInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputOriginInfo mallocStack(MemoryStack stack) {
        return InputOriginInfo.malloc(stack);
    }

    @Deprecated
    public static InputOriginInfo callocStack(MemoryStack stack) {
        return InputOriginInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputOriginInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputOriginInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputOriginInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputOriginInfo.calloc(capacity, stack);
    }

    public static InputOriginInfo malloc(MemoryStack stack) {
        return InputOriginInfo.wrap(InputOriginInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputOriginInfo calloc(MemoryStack stack) {
        return InputOriginInfo.wrap(InputOriginInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return InputOriginInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return InputOriginInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndevicePath(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEPATH);
    }

    public static int ntrackedDeviceIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRACKEDDEVICEINDEX);
    }

    public static ByteBuffer nrchRenderModelComponentName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RCHRENDERMODELCOMPONENTNAME, 128);
    }

    public static String nrchRenderModelComponentNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)RCHRENDERMODELCOMPONENTNAME);
    }

    static {
        Struct.Layout layout = InputOriginInfo.__struct(InputOriginInfo.__member(8), InputOriginInfo.__member(4), InputOriginInfo.__array(1, 128));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEPATH = layout.offsetof(0);
        TRACKEDDEVICEINDEX = layout.offsetof(1);
        RCHRENDERMODELCOMPONENTNAME = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<InputOriginInfo, Buffer>
    implements NativeResource {
        private static final InputOriginInfo ELEMENT_FACTORY = InputOriginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected InputOriginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VRInputValueHandle_t")
        public long devicePath() {
            return InputOriginInfo.ndevicePath(this.address());
        }

        @NativeType(value="TrackedDeviceIndex_t")
        public int trackedDeviceIndex() {
            return InputOriginInfo.ntrackedDeviceIndex(this.address());
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchRenderModelComponentName() {
            return InputOriginInfo.nrchRenderModelComponentName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchRenderModelComponentNameString() {
            return InputOriginInfo.nrchRenderModelComponentNameString(this.address());
        }
    }
}

