/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct NotificationBitmap_t")
public class NotificationBitmap
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_PIMAGEDATA;
    public static final int M_NWIDTH;
    public static final int M_NHEIGHT;
    public static final int M_NBYTESPERPIXEL;

    public NotificationBitmap(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NotificationBitmap.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer m_pImageData(int capacity) {
        return NotificationBitmap.nm_pImageData(this.address(), capacity);
    }

    @NativeType(value="int32_t")
    public int m_nWidth() {
        return NotificationBitmap.nm_nWidth(this.address());
    }

    @NativeType(value="int32_t")
    public int m_nHeight() {
        return NotificationBitmap.nm_nHeight(this.address());
    }

    @NativeType(value="int32_t")
    public int m_nBytesPerPixel() {
        return NotificationBitmap.nm_nBytesPerPixel(this.address());
    }

    public NotificationBitmap m_pImageData(@NativeType(value="void *") ByteBuffer value) {
        NotificationBitmap.nm_pImageData(this.address(), value);
        return this;
    }

    public NotificationBitmap m_nWidth(@NativeType(value="int32_t") int value) {
        NotificationBitmap.nm_nWidth(this.address(), value);
        return this;
    }

    public NotificationBitmap m_nHeight(@NativeType(value="int32_t") int value) {
        NotificationBitmap.nm_nHeight(this.address(), value);
        return this;
    }

    public NotificationBitmap m_nBytesPerPixel(@NativeType(value="int32_t") int value) {
        NotificationBitmap.nm_nBytesPerPixel(this.address(), value);
        return this;
    }

    public NotificationBitmap set(ByteBuffer m_pImageData, int m_nWidth, int m_nHeight, int m_nBytesPerPixel) {
        this.m_pImageData(m_pImageData);
        this.m_nWidth(m_nWidth);
        this.m_nHeight(m_nHeight);
        this.m_nBytesPerPixel(m_nBytesPerPixel);
        return this;
    }

    public NotificationBitmap set(NotificationBitmap src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NotificationBitmap malloc() {
        return NotificationBitmap.wrap(NotificationBitmap.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NotificationBitmap calloc() {
        return NotificationBitmap.wrap(NotificationBitmap.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NotificationBitmap create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NotificationBitmap.wrap(NotificationBitmap.class, MemoryUtil.memAddress(container), container);
    }

    public static NotificationBitmap create(long address) {
        return NotificationBitmap.wrap(NotificationBitmap.class, address);
    }

    @Nullable
    public static NotificationBitmap createSafe(long address) {
        return address == 0L ? null : NotificationBitmap.wrap(NotificationBitmap.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NotificationBitmap.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NotificationBitmap.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NotificationBitmap.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NotificationBitmap.__create(capacity, SIZEOF);
        return NotificationBitmap.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NotificationBitmap.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NotificationBitmap.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NotificationBitmap mallocStack() {
        return NotificationBitmap.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NotificationBitmap callocStack() {
        return NotificationBitmap.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NotificationBitmap mallocStack(MemoryStack stack) {
        return NotificationBitmap.malloc(stack);
    }

    @Deprecated
    public static NotificationBitmap callocStack(MemoryStack stack) {
        return NotificationBitmap.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NotificationBitmap.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NotificationBitmap.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NotificationBitmap.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NotificationBitmap.calloc(capacity, stack);
    }

    public static NotificationBitmap malloc(MemoryStack stack) {
        return NotificationBitmap.wrap(NotificationBitmap.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NotificationBitmap calloc(MemoryStack stack) {
        return NotificationBitmap.wrap(NotificationBitmap.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NotificationBitmap.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NotificationBitmap.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nm_pImageData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)M_PIMAGEDATA), capacity);
    }

    public static int nm_nWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NWIDTH);
    }

    public static int nm_nHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NHEIGHT);
    }

    public static int nm_nBytesPerPixel(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NBYTESPERPIXEL);
    }

    public static void nm_pImageData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)M_PIMAGEDATA, MemoryUtil.memAddress(value));
    }

    public static void nm_nWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NWIDTH, value);
    }

    public static void nm_nHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NHEIGHT, value);
    }

    public static void nm_nBytesPerPixel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NBYTESPERPIXEL, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)M_PIMAGEDATA));
    }

    static {
        Struct.Layout layout = NotificationBitmap.__struct(NotificationBitmap.__member(POINTER_SIZE), NotificationBitmap.__member(4), NotificationBitmap.__member(4), NotificationBitmap.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_PIMAGEDATA = layout.offsetof(0);
        M_NWIDTH = layout.offsetof(1);
        M_NHEIGHT = layout.offsetof(2);
        M_NBYTESPERPIXEL = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NotificationBitmap, Buffer>
    implements NativeResource {
        private static final NotificationBitmap ELEMENT_FACTORY = NotificationBitmap.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NotificationBitmap getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer m_pImageData(int capacity) {
            return NotificationBitmap.nm_pImageData(this.address(), capacity);
        }

        @NativeType(value="int32_t")
        public int m_nWidth() {
            return NotificationBitmap.nm_nWidth(this.address());
        }

        @NativeType(value="int32_t")
        public int m_nHeight() {
            return NotificationBitmap.nm_nHeight(this.address());
        }

        @NativeType(value="int32_t")
        public int m_nBytesPerPixel() {
            return NotificationBitmap.nm_nBytesPerPixel(this.address());
        }

        public Buffer m_pImageData(@NativeType(value="void *") ByteBuffer value) {
            NotificationBitmap.nm_pImageData(this.address(), value);
            return this;
        }

        public Buffer m_nWidth(@NativeType(value="int32_t") int value) {
            NotificationBitmap.nm_nWidth(this.address(), value);
            return this;
        }

        public Buffer m_nHeight(@NativeType(value="int32_t") int value) {
            NotificationBitmap.nm_nHeight(this.address(), value);
            return this;
        }

        public Buffer m_nBytesPerPixel(@NativeType(value="int32_t") int value) {
            NotificationBitmap.nm_nBytesPerPixel(this.address(), value);
            return this;
        }
    }
}

