/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRActiveActionSet_t")
public class VRActiveActionSet
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ULACTIONSET;
    public static final int ULRESTRICTEDTODEVICE;
    public static final int ULSECONDARYACTIONSET;
    public static final int NPRIORITY;

    public VRActiveActionSet(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VRActiveActionSet.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VRActionSetHandle_t")
    public long ulActionSet() {
        return VRActiveActionSet.nulActionSet(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long ulRestrictedToDevice() {
        return VRActiveActionSet.nulRestrictedToDevice(this.address());
    }

    @NativeType(value="VRActionSetHandle_t")
    public long ulSecondaryActionSet() {
        return VRActiveActionSet.nulSecondaryActionSet(this.address());
    }

    @NativeType(value="int32_t")
    public int nPriority() {
        return VRActiveActionSet.nnPriority(this.address());
    }

    public VRActiveActionSet ulActionSet(@NativeType(value="VRActionSetHandle_t") long value) {
        VRActiveActionSet.nulActionSet(this.address(), value);
        return this;
    }

    public VRActiveActionSet ulRestrictedToDevice(@NativeType(value="VRInputValueHandle_t") long value) {
        VRActiveActionSet.nulRestrictedToDevice(this.address(), value);
        return this;
    }

    public VRActiveActionSet ulSecondaryActionSet(@NativeType(value="VRActionSetHandle_t") long value) {
        VRActiveActionSet.nulSecondaryActionSet(this.address(), value);
        return this;
    }

    public VRActiveActionSet nPriority(@NativeType(value="int32_t") int value) {
        VRActiveActionSet.nnPriority(this.address(), value);
        return this;
    }

    public VRActiveActionSet set(long ulActionSet, long ulRestrictedToDevice, long ulSecondaryActionSet, int nPriority) {
        this.ulActionSet(ulActionSet);
        this.ulRestrictedToDevice(ulRestrictedToDevice);
        this.ulSecondaryActionSet(ulSecondaryActionSet);
        this.nPriority(nPriority);
        return this;
    }

    public VRActiveActionSet set(VRActiveActionSet src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRActiveActionSet malloc() {
        return VRActiveActionSet.wrap(VRActiveActionSet.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VRActiveActionSet calloc() {
        return VRActiveActionSet.wrap(VRActiveActionSet.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VRActiveActionSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VRActiveActionSet.wrap(VRActiveActionSet.class, MemoryUtil.memAddress(container), container);
    }

    public static VRActiveActionSet create(long address) {
        return VRActiveActionSet.wrap(VRActiveActionSet.class, address);
    }

    @Nullable
    public static VRActiveActionSet createSafe(long address) {
        return address == 0L ? null : VRActiveActionSet.wrap(VRActiveActionSet.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VRActiveActionSet.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VRActiveActionSet.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VRActiveActionSet.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRActiveActionSet.__create(capacity, SIZEOF);
        return VRActiveActionSet.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VRActiveActionSet.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VRActiveActionSet.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VRActiveActionSet mallocStack() {
        return VRActiveActionSet.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRActiveActionSet callocStack() {
        return VRActiveActionSet.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRActiveActionSet mallocStack(MemoryStack stack) {
        return VRActiveActionSet.malloc(stack);
    }

    @Deprecated
    public static VRActiveActionSet callocStack(MemoryStack stack) {
        return VRActiveActionSet.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VRActiveActionSet.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VRActiveActionSet.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRActiveActionSet.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRActiveActionSet.calloc(capacity, stack);
    }

    public static VRActiveActionSet malloc(MemoryStack stack) {
        return VRActiveActionSet.wrap(VRActiveActionSet.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VRActiveActionSet calloc(MemoryStack stack) {
        return VRActiveActionSet.wrap(VRActiveActionSet.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VRActiveActionSet.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VRActiveActionSet.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nulActionSet(long struct) {
        return UNSAFE.getLong(null, struct + (long)ULACTIONSET);
    }

    public static long nulRestrictedToDevice(long struct) {
        return UNSAFE.getLong(null, struct + (long)ULRESTRICTEDTODEVICE);
    }

    public static long nulSecondaryActionSet(long struct) {
        return UNSAFE.getLong(null, struct + (long)ULSECONDARYACTIONSET);
    }

    public static int nnPriority(long struct) {
        return UNSAFE.getInt(null, struct + (long)NPRIORITY);
    }

    public static void nulActionSet(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ULACTIONSET, value);
    }

    public static void nulRestrictedToDevice(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ULRESTRICTEDTODEVICE, value);
    }

    public static void nulSecondaryActionSet(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ULSECONDARYACTIONSET, value);
    }

    public static void nnPriority(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NPRIORITY, value);
    }

    static {
        Struct.Layout layout = VRActiveActionSet.__struct(VRActiveActionSet.__member(8), VRActiveActionSet.__member(8), VRActiveActionSet.__member(8), VRActiveActionSet.__padding(4, true), VRActiveActionSet.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ULACTIONSET = layout.offsetof(0);
        ULRESTRICTEDTODEVICE = layout.offsetof(1);
        ULSECONDARYACTIONSET = layout.offsetof(2);
        NPRIORITY = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VRActiveActionSet, Buffer>
    implements NativeResource {
        private static final VRActiveActionSet ELEMENT_FACTORY = VRActiveActionSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VRActiveActionSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VRActionSetHandle_t")
        public long ulActionSet() {
            return VRActiveActionSet.nulActionSet(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long ulRestrictedToDevice() {
            return VRActiveActionSet.nulRestrictedToDevice(this.address());
        }

        @NativeType(value="VRActionSetHandle_t")
        public long ulSecondaryActionSet() {
            return VRActiveActionSet.nulSecondaryActionSet(this.address());
        }

        @NativeType(value="int32_t")
        public int nPriority() {
            return VRActiveActionSet.nnPriority(this.address());
        }

        public Buffer ulActionSet(@NativeType(value="VRActionSetHandle_t") long value) {
            VRActiveActionSet.nulActionSet(this.address(), value);
            return this;
        }

        public Buffer ulRestrictedToDevice(@NativeType(value="VRInputValueHandle_t") long value) {
            VRActiveActionSet.nulRestrictedToDevice(this.address(), value);
            return this;
        }

        public Buffer ulSecondaryActionSet(@NativeType(value="VRActionSetHandle_t") long value) {
            VRActiveActionSet.nulSecondaryActionSet(this.address(), value);
            return this;
        }

        public Buffer nPriority(@NativeType(value="int32_t") int value) {
            VRActiveActionSet.nnPriority(this.address(), value);
            return this;
        }
    }
}

