/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.NotificationBitmap;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRNotifications {
    protected VRNotifications() {
        throw new UnsupportedOperationException();
    }

    public static int nVRNotifications_CreateNotification(long ulOverlayHandle, long ulUserValue, int type, long pchText, int style, long pImage, long pNotificationId) {
        long __functionAddress = OpenVR.VRNotifications.CreateNotification;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pImage != 0L) {
                NotificationBitmap.validate(pImage);
            }
        }
        return JNI.callJJPPPI(ulOverlayHandle, ulUserValue, type, pchText, style, pImage, pNotificationId, __functionAddress);
    }

    @NativeType(value="EVRNotificationError")
    public static int VRNotifications_CreateNotification(@NativeType(value="VROverlayHandle_t") long ulOverlayHandle, @NativeType(value="uint64_t") long ulUserValue, @NativeType(value="EVRNotificationType") int type, @NativeType(value="char const *") ByteBuffer pchText, @NativeType(value="EVRNotificationStyle") int style, @Nullable @NativeType(value="NotificationBitmap_t const *") NotificationBitmap pImage, @NativeType(value="VRNotificationId *") IntBuffer pNotificationId) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchText);
            Checks.check((Buffer)pNotificationId, 1);
        }
        return VRNotifications.nVRNotifications_CreateNotification(ulOverlayHandle, ulUserValue, type, MemoryUtil.memAddress(pchText), style, MemoryUtil.memAddressSafe(pImage), MemoryUtil.memAddress(pNotificationId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRNotificationError")
    public static int VRNotifications_CreateNotification(@NativeType(value="VROverlayHandle_t") long ulOverlayHandle, @NativeType(value="uint64_t") long ulUserValue, @NativeType(value="EVRNotificationType") int type, @NativeType(value="char const *") CharSequence pchText, @NativeType(value="EVRNotificationStyle") int style, @Nullable @NativeType(value="NotificationBitmap_t const *") NotificationBitmap pImage, @NativeType(value="VRNotificationId *") IntBuffer pNotificationId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pNotificationId, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchText, true);
            long pchTextEncoded = stack.getPointerAddress();
            int n = VRNotifications.nVRNotifications_CreateNotification(ulOverlayHandle, ulUserValue, type, pchTextEncoded, style, MemoryUtil.memAddressSafe(pImage), MemoryUtil.memAddress(pNotificationId));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="EVRNotificationError")
    public static int VRNotifications_RemoveNotification(@NativeType(value="VRNotificationId") int notificationId) {
        long __functionAddress = OpenVR.VRNotifications.RemoveNotification;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(notificationId, __functionAddress);
    }
}

