/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VROverlayIntersectionResults_t")
public class VROverlayIntersectionResults
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VPOINT;
    public static final int VNORMAL;
    public static final int VUVS;
    public static final int FDISTANCE;

    public VROverlayIntersectionResults(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VROverlayIntersectionResults.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vPoint() {
        return VROverlayIntersectionResults.nvPoint(this.address());
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vNormal() {
        return VROverlayIntersectionResults.nvNormal(this.address());
    }

    @NativeType(value="HmdVector2_t")
    public HmdVector2 vUVs() {
        return VROverlayIntersectionResults.nvUVs(this.address());
    }

    public float fDistance() {
        return VROverlayIntersectionResults.nfDistance(this.address());
    }

    public static VROverlayIntersectionResults malloc() {
        return VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VROverlayIntersectionResults calloc() {
        return VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VROverlayIntersectionResults create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, MemoryUtil.memAddress(container), container);
    }

    public static VROverlayIntersectionResults create(long address) {
        return VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, address);
    }

    @Nullable
    public static VROverlayIntersectionResults createSafe(long address) {
        return address == 0L ? null : VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VROverlayIntersectionResults.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VROverlayIntersectionResults.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VROverlayIntersectionResults.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VROverlayIntersectionResults.__create(capacity, SIZEOF);
        return VROverlayIntersectionResults.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VROverlayIntersectionResults.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VROverlayIntersectionResults.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VROverlayIntersectionResults mallocStack() {
        return VROverlayIntersectionResults.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VROverlayIntersectionResults callocStack() {
        return VROverlayIntersectionResults.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VROverlayIntersectionResults mallocStack(MemoryStack stack) {
        return VROverlayIntersectionResults.malloc(stack);
    }

    @Deprecated
    public static VROverlayIntersectionResults callocStack(MemoryStack stack) {
        return VROverlayIntersectionResults.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VROverlayIntersectionResults.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VROverlayIntersectionResults.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionResults.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionResults.calloc(capacity, stack);
    }

    public static VROverlayIntersectionResults malloc(MemoryStack stack) {
        return VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VROverlayIntersectionResults calloc(MemoryStack stack) {
        return VROverlayIntersectionResults.wrap(VROverlayIntersectionResults.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VROverlayIntersectionResults.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VROverlayIntersectionResults.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector3 nvPoint(long struct) {
        return HmdVector3.create(struct + (long)VPOINT);
    }

    public static HmdVector3 nvNormal(long struct) {
        return HmdVector3.create(struct + (long)VNORMAL);
    }

    public static HmdVector2 nvUVs(long struct) {
        return HmdVector2.create(struct + (long)VUVS);
    }

    public static float nfDistance(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FDISTANCE);
    }

    static {
        Struct.Layout layout = VROverlayIntersectionResults.__struct(VROverlayIntersectionResults.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionResults.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionResults.__member(HmdVector2.SIZEOF, HmdVector2.ALIGNOF), VROverlayIntersectionResults.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VPOINT = layout.offsetof(0);
        VNORMAL = layout.offsetof(1);
        VUVS = layout.offsetof(2);
        FDISTANCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VROverlayIntersectionResults, Buffer>
    implements NativeResource {
        private static final VROverlayIntersectionResults ELEMENT_FACTORY = VROverlayIntersectionResults.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VROverlayIntersectionResults getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vPoint() {
            return VROverlayIntersectionResults.nvPoint(this.address());
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vNormal() {
            return VROverlayIntersectionResults.nvNormal(this.address());
        }

        @NativeType(value="HmdVector2_t")
        public HmdVector2 vUVs() {
            return VROverlayIntersectionResults.nvUVs(this.address());
        }

        public float fDistance() {
            return VROverlayIntersectionResults.nfDistance(this.address());
        }
    }
}

