/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.VRTextureDepthInfo;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRTextureWithDepth_t")
public class VRTextureWithDepth
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int ETYPE;
    public static final int ECOLORSPACE;
    public static final int DEPTH;

    public VRTextureWithDepth(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VRTextureWithDepth.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return VRTextureWithDepth.nhandle(this.address());
    }

    @NativeType(value="ETextureType")
    public int eType() {
        return VRTextureWithDepth.neType(this.address());
    }

    @NativeType(value="EColorSpace")
    public int eColorSpace() {
        return VRTextureWithDepth.neColorSpace(this.address());
    }

    @NativeType(value="VRTextureDepthInfo_t")
    public VRTextureDepthInfo depth() {
        return VRTextureWithDepth.ndepth(this.address());
    }

    public VRTextureWithDepth handle(@NativeType(value="void *") long value) {
        VRTextureWithDepth.nhandle(this.address(), value);
        return this;
    }

    public VRTextureWithDepth eType(@NativeType(value="ETextureType") int value) {
        VRTextureWithDepth.neType(this.address(), value);
        return this;
    }

    public VRTextureWithDepth eColorSpace(@NativeType(value="EColorSpace") int value) {
        VRTextureWithDepth.neColorSpace(this.address(), value);
        return this;
    }

    public VRTextureWithDepth depth(@NativeType(value="VRTextureDepthInfo_t") VRTextureDepthInfo value) {
        VRTextureWithDepth.ndepth(this.address(), value);
        return this;
    }

    public VRTextureWithDepth depth(Consumer<VRTextureDepthInfo> consumer) {
        consumer.accept(this.depth());
        return this;
    }

    public VRTextureWithDepth set(long handle, int eType, int eColorSpace, VRTextureDepthInfo depth) {
        this.handle(handle);
        this.eType(eType);
        this.eColorSpace(eColorSpace);
        this.depth(depth);
        return this;
    }

    public VRTextureWithDepth set(VRTextureWithDepth src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRTextureWithDepth malloc() {
        return VRTextureWithDepth.wrap(VRTextureWithDepth.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VRTextureWithDepth calloc() {
        return VRTextureWithDepth.wrap(VRTextureWithDepth.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VRTextureWithDepth create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VRTextureWithDepth.wrap(VRTextureWithDepth.class, MemoryUtil.memAddress(container), container);
    }

    public static VRTextureWithDepth create(long address) {
        return VRTextureWithDepth.wrap(VRTextureWithDepth.class, address);
    }

    @Nullable
    public static VRTextureWithDepth createSafe(long address) {
        return address == 0L ? null : VRTextureWithDepth.wrap(VRTextureWithDepth.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VRTextureWithDepth.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VRTextureWithDepth.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VRTextureWithDepth.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRTextureWithDepth.__create(capacity, SIZEOF);
        return VRTextureWithDepth.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VRTextureWithDepth.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VRTextureWithDepth.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VRTextureWithDepth mallocStack() {
        return VRTextureWithDepth.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureWithDepth callocStack() {
        return VRTextureWithDepth.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureWithDepth mallocStack(MemoryStack stack) {
        return VRTextureWithDepth.malloc(stack);
    }

    @Deprecated
    public static VRTextureWithDepth callocStack(MemoryStack stack) {
        return VRTextureWithDepth.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VRTextureWithDepth.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VRTextureWithDepth.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRTextureWithDepth.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRTextureWithDepth.calloc(capacity, stack);
    }

    public static VRTextureWithDepth malloc(MemoryStack stack) {
        return VRTextureWithDepth.wrap(VRTextureWithDepth.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VRTextureWithDepth calloc(MemoryStack stack) {
        return VRTextureWithDepth.wrap(VRTextureWithDepth.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VRTextureWithDepth.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VRTextureWithDepth.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static int neType(long struct) {
        return UNSAFE.getInt(null, struct + (long)ETYPE);
    }

    public static int neColorSpace(long struct) {
        return UNSAFE.getInt(null, struct + (long)ECOLORSPACE);
    }

    public static VRTextureDepthInfo ndepth(long struct) {
        return VRTextureDepthInfo.create(struct + (long)DEPTH);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void neType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ETYPE, value);
    }

    public static void neColorSpace(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ECOLORSPACE, value);
    }

    public static void ndepth(long struct, VRTextureDepthInfo value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEPTH, VRTextureDepthInfo.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
        VRTextureDepthInfo.validate(struct + (long)DEPTH);
    }

    static {
        Struct.Layout layout = VRTextureWithDepth.__struct(VRTextureWithDepth.__member(POINTER_SIZE), VRTextureWithDepth.__member(4), VRTextureWithDepth.__member(4), VRTextureWithDepth.__member(VRTextureDepthInfo.SIZEOF, VRTextureDepthInfo.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        ETYPE = layout.offsetof(1);
        ECOLORSPACE = layout.offsetof(2);
        DEPTH = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VRTextureWithDepth, Buffer>
    implements NativeResource {
        private static final VRTextureWithDepth ELEMENT_FACTORY = VRTextureWithDepth.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VRTextureWithDepth getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return VRTextureWithDepth.nhandle(this.address());
        }

        @NativeType(value="ETextureType")
        public int eType() {
            return VRTextureWithDepth.neType(this.address());
        }

        @NativeType(value="EColorSpace")
        public int eColorSpace() {
            return VRTextureWithDepth.neColorSpace(this.address());
        }

        @NativeType(value="VRTextureDepthInfo_t")
        public VRTextureDepthInfo depth() {
            return VRTextureWithDepth.ndepth(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            VRTextureWithDepth.nhandle(this.address(), value);
            return this;
        }

        public Buffer eType(@NativeType(value="ETextureType") int value) {
            VRTextureWithDepth.neType(this.address(), value);
            return this;
        }

        public Buffer eColorSpace(@NativeType(value="EColorSpace") int value) {
            VRTextureWithDepth.neColorSpace(this.address(), value);
            return this;
        }

        public Buffer depth(@NativeType(value="VRTextureDepthInfo_t") VRTextureDepthInfo value) {
            VRTextureWithDepth.ndepth(this.address(), value);
            return this;
        }

        public Buffer depth(Consumer<VRTextureDepthInfo> consumer) {
            consumer.accept(this.depth());
            return this;
        }
    }
}

