/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrGraphicsRequirementsVulkanKHR;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkInstance;

public class KHRVulkanEnable {
    public static final int XR_KHR_vulkan_enable_SPEC_VERSION = 8;
    public static final String XR_KHR_VULKAN_ENABLE_EXTENSION_NAME = "XR_KHR_vulkan_enable";
    public static final int XR_TYPE_GRAPHICS_BINDING_VULKAN_KHR = 1000025000;
    public static final int XR_TYPE_SWAPCHAIN_IMAGE_VULKAN_KHR = 1000025001;
    public static final int XR_TYPE_GRAPHICS_REQUIREMENTS_VULKAN_KHR = 1000025002;

    protected KHRVulkanEnable() {
        throw new UnsupportedOperationException();
    }

    public static int nxrGetVulkanInstanceExtensionsKHR(XrInstance instance, long systemId, int bufferCapacityInput, long bufferCountOutput, long buffer) {
        long __functionAddress = instance.getCapabilities().xrGetVulkanInstanceExtensionsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(instance.address(), systemId, bufferCapacityInput, bufferCountOutput, buffer, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetVulkanInstanceExtensionsKHR(XrInstance instance, @NativeType(value="XrSystemId") long systemId, @NativeType(value="uint32_t *") IntBuffer bufferCountOutput, @Nullable @NativeType(value="char *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bufferCountOutput, 1);
        }
        return KHRVulkanEnable.nxrGetVulkanInstanceExtensionsKHR(instance, systemId, Checks.remainingSafe(buffer), MemoryUtil.memAddress(bufferCountOutput), MemoryUtil.memAddressSafe(buffer));
    }

    public static int nxrGetVulkanDeviceExtensionsKHR(XrInstance instance, long systemId, int bufferCapacityInput, long bufferCountOutput, long buffer) {
        long __functionAddress = instance.getCapabilities().xrGetVulkanDeviceExtensionsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(instance.address(), systemId, bufferCapacityInput, bufferCountOutput, buffer, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetVulkanDeviceExtensionsKHR(XrInstance instance, @NativeType(value="XrSystemId") long systemId, @NativeType(value="uint32_t *") IntBuffer bufferCountOutput, @Nullable @NativeType(value="char *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bufferCountOutput, 1);
        }
        return KHRVulkanEnable.nxrGetVulkanDeviceExtensionsKHR(instance, systemId, Checks.remainingSafe(buffer), MemoryUtil.memAddress(bufferCountOutput), MemoryUtil.memAddressSafe(buffer));
    }

    public static int nxrGetVulkanGraphicsDeviceKHR(XrInstance instance, long systemId, VkInstance vkInstance, long vkPhysicalDevice) {
        long __functionAddress = instance.getCapabilities().xrGetVulkanGraphicsDeviceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(instance.address(), systemId, vkInstance.address(), vkPhysicalDevice, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetVulkanGraphicsDeviceKHR(XrInstance instance, @NativeType(value="XrSystemId") long systemId, VkInstance vkInstance, @NativeType(value="VkPhysicalDevice *") PointerBuffer vkPhysicalDevice) {
        if (Checks.CHECKS) {
            Checks.check(vkPhysicalDevice, 1);
        }
        return KHRVulkanEnable.nxrGetVulkanGraphicsDeviceKHR(instance, systemId, vkInstance, MemoryUtil.memAddress(vkPhysicalDevice));
    }

    public static int nxrGetVulkanGraphicsRequirementsKHR(XrInstance instance, long systemId, long graphicsRequirements) {
        long __functionAddress = instance.getCapabilities().xrGetVulkanGraphicsRequirementsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(instance.address(), systemId, graphicsRequirements, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetVulkanGraphicsRequirementsKHR(XrInstance instance, @NativeType(value="XrSystemId") long systemId, @NativeType(value="XrGraphicsRequirementsVulkanKHR *") XrGraphicsRequirementsVulkanKHR graphicsRequirements) {
        return KHRVulkanEnable.nxrGetVulkanGraphicsRequirementsKHR(instance, systemId, graphicsRequirements.address());
    }
}

