/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrHandMeshMSFT;
import org.lwjgl.openxr.XrHandMeshSpaceCreateInfoMSFT;
import org.lwjgl.openxr.XrHandMeshUpdateInfoMSFT;
import org.lwjgl.openxr.XrHandTrackerEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MSFTHandTrackingMesh {
    public static final int XR_MSFT_hand_tracking_mesh_SPEC_VERSION = 4;
    public static final String XR_MSFT_HAND_TRACKING_MESH_EXTENSION_NAME = "XR_MSFT_hand_tracking_mesh";
    public static final int XR_TYPE_SYSTEM_HAND_TRACKING_MESH_PROPERTIES_MSFT = 1000052000;
    public static final int XR_TYPE_HAND_MESH_SPACE_CREATE_INFO_MSFT = 1000052001;
    public static final int XR_TYPE_HAND_MESH_UPDATE_INFO_MSFT = 1000052002;
    public static final int XR_TYPE_HAND_MESH_MSFT = 1000052003;
    public static final int XR_TYPE_HAND_POSE_TYPE_INFO_MSFT = 1000052004;
    public static final int XR_HAND_POSE_TYPE_TRACKED_MSFT = 0;
    public static final int XR_HAND_POSE_TYPE_REFERENCE_OPEN_PALM_MSFT = 1;

    protected MSFTHandTrackingMesh() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreateHandMeshSpaceMSFT(XrHandTrackerEXT handTracker, long createInfo, long space) {
        long __functionAddress = handTracker.getCapabilities().xrCreateHandMeshSpaceMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(handTracker.address(), createInfo, space, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateHandMeshSpaceMSFT(XrHandTrackerEXT handTracker, @NativeType(value="XrHandMeshSpaceCreateInfoMSFT const *") XrHandMeshSpaceCreateInfoMSFT createInfo, @NativeType(value="XrSpace *") PointerBuffer space) {
        if (Checks.CHECKS) {
            Checks.check(space, 1);
        }
        return MSFTHandTrackingMesh.nxrCreateHandMeshSpaceMSFT(handTracker, createInfo.address(), MemoryUtil.memAddress(space));
    }

    public static int nxrUpdateHandMeshMSFT(XrHandTrackerEXT handTracker, long updateInfo, long handMesh) {
        long __functionAddress = handTracker.getCapabilities().xrUpdateHandMeshMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(handTracker.address(), updateInfo, handMesh, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrUpdateHandMeshMSFT(XrHandTrackerEXT handTracker, @NativeType(value="XrHandMeshUpdateInfoMSFT const *") XrHandMeshUpdateInfoMSFT updateInfo, @NativeType(value="XrHandMeshMSFT *") XrHandMeshMSFT handMesh) {
        return MSFTHandTrackingMesh.nxrUpdateHandMeshMSFT(handTracker, updateInfo.address(), handMesh.address());
    }
}

