/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrNewSceneComputeInfoMSFT;
import org.lwjgl.openxr.XrSceneComponentLocationsMSFT;
import org.lwjgl.openxr.XrSceneComponentsGetInfoMSFT;
import org.lwjgl.openxr.XrSceneComponentsLocateInfoMSFT;
import org.lwjgl.openxr.XrSceneComponentsMSFT;
import org.lwjgl.openxr.XrSceneCreateInfoMSFT;
import org.lwjgl.openxr.XrSceneMSFT;
import org.lwjgl.openxr.XrSceneMeshBuffersGetInfoMSFT;
import org.lwjgl.openxr.XrSceneMeshBuffersMSFT;
import org.lwjgl.openxr.XrSceneObserverCreateInfoMSFT;
import org.lwjgl.openxr.XrSceneObserverMSFT;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MSFTSceneUnderstanding {
    public static final int XR_MSFT_scene_understanding_SPEC_VERSION = 1;
    public static final String XR_MSFT_SCENE_UNDERSTANDING_EXTENSION_NAME = "XR_MSFT_scene_understanding";
    public static final int XR_OBJECT_TYPE_SCENE_OBSERVER_MSFT = 1000097000;
    public static final int XR_OBJECT_TYPE_SCENE_MSFT = 1000097001;
    public static final int XR_TYPE_SCENE_OBSERVER_CREATE_INFO_MSFT = 1000097000;
    public static final int XR_TYPE_SCENE_CREATE_INFO_MSFT = 1000097001;
    public static final int XR_TYPE_NEW_SCENE_COMPUTE_INFO_MSFT = 1000097002;
    public static final int XR_TYPE_VISUAL_MESH_COMPUTE_LOD_INFO_MSFT = 1000097003;
    public static final int XR_TYPE_SCENE_COMPONENTS_MSFT = 1000097004;
    public static final int XR_TYPE_SCENE_COMPONENTS_GET_INFO_MSFT = 1000097005;
    public static final int XR_TYPE_SCENE_COMPONENT_LOCATIONS_MSFT = 1000097006;
    public static final int XR_TYPE_SCENE_COMPONENTS_LOCATE_INFO_MSFT = 1000097007;
    public static final int XR_TYPE_SCENE_OBJECTS_MSFT = 1000097008;
    public static final int XR_TYPE_SCENE_COMPONENT_PARENT_FILTER_INFO_MSFT = 1000097009;
    public static final int XR_TYPE_SCENE_OBJECT_TYPES_FILTER_INFO_MSFT = 1000097010;
    public static final int XR_TYPE_SCENE_PLANES_MSFT = 1000097011;
    public static final int XR_TYPE_SCENE_PLANE_ALIGNMENT_FILTER_INFO_MSFT = 1000097012;
    public static final int XR_TYPE_SCENE_MESHES_MSFT = 1000097013;
    public static final int XR_TYPE_SCENE_MESH_BUFFERS_GET_INFO_MSFT = 1000097014;
    public static final int XR_TYPE_SCENE_MESH_BUFFERS_MSFT = 1000097015;
    public static final int XR_TYPE_SCENE_MESH_VERTEX_BUFFER_MSFT = 1000097016;
    public static final int XR_TYPE_SCENE_MESH_INDICES_UINT32_MSFT = 1000097017;
    public static final int XR_TYPE_SCENE_MESH_INDICES_UINT16_MSFT = 1000097018;
    public static final int XR_ERROR_COMPUTE_NEW_SCENE_NOT_COMPLETED_MSFT = -1000097000;
    public static final int XR_ERROR_SCENE_COMPONENT_ID_INVALID_MSFT = -1000097001;
    public static final int XR_ERROR_SCENE_COMPONENT_TYPE_MISMATCH_MSFT = -1000097002;
    public static final int XR_ERROR_SCENE_MESH_BUFFER_ID_INVALID_MSFT = -1000097003;
    public static final int XR_ERROR_SCENE_COMPUTE_FEATURE_INCOMPATIBLE_MSFT = -1000097004;
    public static final int XR_ERROR_SCENE_COMPUTE_CONSISTENCY_MISMATCH_MSFT = -1000097005;
    public static final int XR_SCENE_COMPUTE_FEATURE_PLANE_MSFT = 1;
    public static final int XR_SCENE_COMPUTE_FEATURE_PLANE_MESH_MSFT = 2;
    public static final int XR_SCENE_COMPUTE_FEATURE_VISUAL_MESH_MSFT = 3;
    public static final int XR_SCENE_COMPUTE_FEATURE_COLLIDER_MESH_MSFT = 4;
    public static final int XR_SCENE_COMPUTE_CONSISTENCY_SNAPSHOT_COMPLETE_MSFT = 1;
    public static final int XR_SCENE_COMPUTE_CONSISTENCY_SNAPSHOT_INCOMPLETE_FAST_MSFT = 2;
    public static final int XR_SCENE_COMPUTE_CONSISTENCY_OCCLUSION_OPTIMIZED_MSFT = 3;
    public static final int XR_MESH_COMPUTE_LOD_COARSE_MSFT = 1;
    public static final int XR_MESH_COMPUTE_LOD_MEDIUM_MSFT = 2;
    public static final int XR_MESH_COMPUTE_LOD_FINE_MSFT = 3;
    public static final int XR_MESH_COMPUTE_LOD_UNLIMITED_MSFT = 4;
    public static final int XR_SCENE_COMPONENT_TYPE_INVALID_MSFT = -1;
    public static final int XR_SCENE_COMPONENT_TYPE_OBJECT_MSFT = 1;
    public static final int XR_SCENE_COMPONENT_TYPE_PLANE_MSFT = 2;
    public static final int XR_SCENE_COMPONENT_TYPE_VISUAL_MESH_MSFT = 3;
    public static final int XR_SCENE_COMPONENT_TYPE_COLLIDER_MESH_MSFT = 4;
    public static final int XR_SCENE_OBJECT_TYPE_UNCATEGORIZED_MSFT = -1;
    public static final int XR_SCENE_OBJECT_TYPE_BACKGROUND_MSFT = 1;
    public static final int XR_SCENE_OBJECT_TYPE_WALL_MSFT = 2;
    public static final int XR_SCENE_OBJECT_TYPE_FLOOR_MSFT = 3;
    public static final int XR_SCENE_OBJECT_TYPE_CEILING_MSFT = 4;
    public static final int XR_SCENE_OBJECT_TYPE_PLATFORM_MSFT = 5;
    public static final int XR_SCENE_OBJECT_TYPE_INFERRED_MSFT = 6;
    public static final int XR_SCENE_PLANE_ALIGNMENT_TYPE_NON_ORTHOGONAL_MSFT = 0;
    public static final int XR_SCENE_PLANE_ALIGNMENT_TYPE_HORIZONTAL_MSFT = 1;
    public static final int XR_SCENE_PLANE_ALIGNMENT_TYPE_VERTICAL_MSFT = 2;
    public static final int XR_SCENE_COMPUTE_STATE_NONE_MSFT = 0;
    public static final int XR_SCENE_COMPUTE_STATE_UPDATING_MSFT = 1;
    public static final int XR_SCENE_COMPUTE_STATE_COMPLETED_MSFT = 2;
    public static final int XR_SCENE_COMPUTE_STATE_COMPLETED_WITH_ERROR_MSFT = 3;

    protected MSFTSceneUnderstanding() {
        throw new UnsupportedOperationException();
    }

    public static int nxrEnumerateSceneComputeFeaturesMSFT(XrInstance instance, long systemId, int featureCapacityInput, long featureCountOutput, long features) {
        long __functionAddress = instance.getCapabilities().xrEnumerateSceneComputeFeaturesMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(instance.address(), systemId, featureCapacityInput, featureCountOutput, features, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumerateSceneComputeFeaturesMSFT(XrInstance instance, @NativeType(value="XrSystemId") long systemId, @NativeType(value="uint32_t *") IntBuffer featureCountOutput, @Nullable @NativeType(value="XrSceneComputeFeatureMSFT *") IntBuffer features) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)featureCountOutput, 1);
        }
        return MSFTSceneUnderstanding.nxrEnumerateSceneComputeFeaturesMSFT(instance, systemId, Checks.remainingSafe(features), MemoryUtil.memAddress(featureCountOutput), MemoryUtil.memAddressSafe(features));
    }

    public static int nxrCreateSceneObserverMSFT(XrSession session, long createInfo, long sceneObserver) {
        long __functionAddress = session.getCapabilities().xrCreateSceneObserverMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(session.address(), createInfo, sceneObserver, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateSceneObserverMSFT(XrSession session, @Nullable @NativeType(value="XrSceneObserverCreateInfoMSFT const *") XrSceneObserverCreateInfoMSFT createInfo, @NativeType(value="XrSceneObserverMSFT *") PointerBuffer sceneObserver) {
        if (Checks.CHECKS) {
            Checks.check(sceneObserver, 1);
        }
        return MSFTSceneUnderstanding.nxrCreateSceneObserverMSFT(session, MemoryUtil.memAddressSafe(createInfo), MemoryUtil.memAddress(sceneObserver));
    }

    @NativeType(value="XrResult")
    public static int xrDestroySceneObserverMSFT(XrSceneObserverMSFT sceneObserver) {
        long __functionAddress = sceneObserver.getCapabilities().xrDestroySceneObserverMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(sceneObserver.address(), __functionAddress);
    }

    public static int nxrCreateSceneMSFT(XrSceneObserverMSFT sceneObserver, long createInfo, long scene) {
        long __functionAddress = sceneObserver.getCapabilities().xrCreateSceneMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(sceneObserver.address(), createInfo, scene, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateSceneMSFT(XrSceneObserverMSFT sceneObserver, @Nullable @NativeType(value="XrSceneCreateInfoMSFT const *") XrSceneCreateInfoMSFT createInfo, @NativeType(value="XrSceneMSFT *") PointerBuffer scene) {
        if (Checks.CHECKS) {
            Checks.check(scene, 1);
        }
        return MSFTSceneUnderstanding.nxrCreateSceneMSFT(sceneObserver, MemoryUtil.memAddressSafe(createInfo), MemoryUtil.memAddress(scene));
    }

    @NativeType(value="XrResult")
    public static int xrDestroySceneMSFT(XrSceneMSFT scene) {
        long __functionAddress = scene.getCapabilities().xrDestroySceneMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(scene.address(), __functionAddress);
    }

    public static int nxrComputeNewSceneMSFT(XrSceneObserverMSFT sceneObserver, long computeInfo) {
        long __functionAddress = sceneObserver.getCapabilities().xrComputeNewSceneMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrNewSceneComputeInfoMSFT.validate(computeInfo);
        }
        return JNI.callPPI(sceneObserver.address(), computeInfo, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrComputeNewSceneMSFT(XrSceneObserverMSFT sceneObserver, @NativeType(value="XrNewSceneComputeInfoMSFT const *") XrNewSceneComputeInfoMSFT computeInfo) {
        return MSFTSceneUnderstanding.nxrComputeNewSceneMSFT(sceneObserver, computeInfo.address());
    }

    public static int nxrGetSceneComputeStateMSFT(XrSceneObserverMSFT sceneObserver, long state) {
        long __functionAddress = sceneObserver.getCapabilities().xrGetSceneComputeStateMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(sceneObserver.address(), state, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetSceneComputeStateMSFT(XrSceneObserverMSFT sceneObserver, @NativeType(value="XrSceneComputeStateMSFT *") IntBuffer state) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)state, 1);
        }
        return MSFTSceneUnderstanding.nxrGetSceneComputeStateMSFT(sceneObserver, MemoryUtil.memAddress(state));
    }

    public static int nxrGetSceneComponentsMSFT(XrSceneMSFT scene, long getInfo, long components) {
        long __functionAddress = scene.getCapabilities().xrGetSceneComponentsMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(scene.address(), getInfo, components, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetSceneComponentsMSFT(XrSceneMSFT scene, @NativeType(value="XrSceneComponentsGetInfoMSFT const *") XrSceneComponentsGetInfoMSFT getInfo, @NativeType(value="XrSceneComponentsMSFT *") XrSceneComponentsMSFT components) {
        return MSFTSceneUnderstanding.nxrGetSceneComponentsMSFT(scene, getInfo.address(), components.address());
    }

    public static int nxrLocateSceneComponentsMSFT(XrSceneMSFT scene, long locateInfo, long locations) {
        long __functionAddress = scene.getCapabilities().xrLocateSceneComponentsMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrSceneComponentsLocateInfoMSFT.validate(locateInfo);
        }
        return JNI.callPPPI(scene.address(), locateInfo, locations, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrLocateSceneComponentsMSFT(XrSceneMSFT scene, @NativeType(value="XrSceneComponentsLocateInfoMSFT const *") XrSceneComponentsLocateInfoMSFT locateInfo, @NativeType(value="XrSceneComponentLocationsMSFT *") XrSceneComponentLocationsMSFT locations) {
        return MSFTSceneUnderstanding.nxrLocateSceneComponentsMSFT(scene, locateInfo.address(), locations.address());
    }

    public static int nxrGetSceneMeshBuffersMSFT(XrSceneMSFT scene, long getInfo, long buffers) {
        long __functionAddress = scene.getCapabilities().xrGetSceneMeshBuffersMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(scene.address(), getInfo, buffers, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetSceneMeshBuffersMSFT(XrSceneMSFT scene, @NativeType(value="XrSceneMeshBuffersGetInfoMSFT const *") XrSceneMeshBuffersGetInfoMSFT getInfo, @NativeType(value="XrSceneMeshBuffersMSFT *") XrSceneMeshBuffersMSFT buffers) {
        return MSFTSceneUnderstanding.nxrGetSceneMeshBuffersMSFT(scene, getInfo.address(), buffers.address());
    }
}

