/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class OCULUSAudioDeviceGuid {
    public static final int XR_OCULUS_audio_device_guid_SPEC_VERSION = 1;
    public static final String XR_OCULUS_AUDIO_DEVICE_GUID_EXTENSION_NAME = "XR_OCULUS_audio_device_guid";
    public static final int XR_MAX_AUDIO_DEVICE_STR_SIZE_OCULUS = 128;

    protected OCULUSAudioDeviceGuid() {
        throw new UnsupportedOperationException();
    }

    public static int nxrGetAudioOutputDeviceGuidOculus(XrInstance instance, long buffer) {
        long __functionAddress = instance.getCapabilities().xrGetAudioOutputDeviceGuidOculus;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(instance.address(), buffer, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetAudioOutputDeviceGuidOculus(XrInstance instance, @NativeType(value="wchar_t *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buffer, 128);
        }
        return OCULUSAudioDeviceGuid.nxrGetAudioOutputDeviceGuidOculus(instance, MemoryUtil.memAddress(buffer));
    }

    public static int nxrGetAudioInputDeviceGuidOculus(XrInstance instance, long buffer) {
        long __functionAddress = instance.getCapabilities().xrGetAudioInputDeviceGuidOculus;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(instance.address(), buffer, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetAudioInputDeviceGuidOculus(XrInstance instance, @NativeType(value="wchar_t *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buffer, 128);
        }
        return OCULUSAudioDeviceGuid.nxrGetAudioInputDeviceGuidOculus(instance, MemoryUtil.memAddress(buffer));
    }
}

