/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionSetCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTIONSETNAME;
    public static final int LOCALIZEDACTIONSETNAME;
    public static final int PRIORITY;

    public XrActionSetCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrActionSetCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionSetCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrActionSetCreateInfo.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]")
    public ByteBuffer actionSetName() {
        return XrActionSetCreateInfo.nactionSetName(this.address());
    }

    @NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]")
    public String actionSetNameString() {
        return XrActionSetCreateInfo.nactionSetNameString(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]")
    public ByteBuffer localizedActionSetName() {
        return XrActionSetCreateInfo.nlocalizedActionSetName(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]")
    public String localizedActionSetNameString() {
        return XrActionSetCreateInfo.nlocalizedActionSetNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int priority() {
        return XrActionSetCreateInfo.npriority(this.address());
    }

    public XrActionSetCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrActionSetCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrActionSetCreateInfo type$Default() {
        return this.type(28);
    }

    public XrActionSetCreateInfo next(@NativeType(value="void const *") long value) {
        XrActionSetCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrActionSetCreateInfo actionSetName(@NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]") ByteBuffer value) {
        XrActionSetCreateInfo.nactionSetName(this.address(), value);
        return this;
    }

    public XrActionSetCreateInfo localizedActionSetName(@NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]") ByteBuffer value) {
        XrActionSetCreateInfo.nlocalizedActionSetName(this.address(), value);
        return this;
    }

    public XrActionSetCreateInfo priority(@NativeType(value="uint32_t") int value) {
        XrActionSetCreateInfo.npriority(this.address(), value);
        return this;
    }

    public XrActionSetCreateInfo set(int type, long next, ByteBuffer actionSetName, ByteBuffer localizedActionSetName, int priority) {
        this.type(type);
        this.next(next);
        this.actionSetName(actionSetName);
        this.localizedActionSetName(localizedActionSetName);
        this.priority(priority);
        return this;
    }

    public XrActionSetCreateInfo set(XrActionSetCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrActionSetCreateInfo malloc() {
        return XrActionSetCreateInfo.wrap(XrActionSetCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrActionSetCreateInfo calloc() {
        return XrActionSetCreateInfo.wrap(XrActionSetCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrActionSetCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrActionSetCreateInfo.wrap(XrActionSetCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static XrActionSetCreateInfo create(long address) {
        return XrActionSetCreateInfo.wrap(XrActionSetCreateInfo.class, address);
    }

    @Nullable
    public static XrActionSetCreateInfo createSafe(long address) {
        return address == 0L ? null : XrActionSetCreateInfo.wrap(XrActionSetCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrActionSetCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrActionSetCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrActionSetCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionSetCreateInfo.__create(capacity, SIZEOF);
        return XrActionSetCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrActionSetCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrActionSetCreateInfo.wrap(Buffer.class, address, capacity);
    }

    public static XrActionSetCreateInfo malloc(MemoryStack stack) {
        return XrActionSetCreateInfo.wrap(XrActionSetCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrActionSetCreateInfo calloc(MemoryStack stack) {
        return XrActionSetCreateInfo.wrap(XrActionSetCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrActionSetCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrActionSetCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static ByteBuffer nactionSetName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)ACTIONSETNAME, 64);
    }

    public static String nactionSetNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)ACTIONSETNAME);
    }

    public static ByteBuffer nlocalizedActionSetName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)LOCALIZEDACTIONSETNAME, 128);
    }

    public static String nlocalizedActionSetNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)LOCALIZEDACTIONSETNAME);
    }

    public static int npriority(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRIORITY);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nactionSetName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)ACTIONSETNAME, value.remaining());
    }

    public static void nlocalizedActionSetName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 128);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)LOCALIZEDACTIONSETNAME, value.remaining());
    }

    public static void npriority(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRIORITY, value);
    }

    static {
        Struct.Layout layout = XrActionSetCreateInfo.__struct(XrActionSetCreateInfo.__member(4), XrActionSetCreateInfo.__member(POINTER_SIZE), XrActionSetCreateInfo.__array(1, 64), XrActionSetCreateInfo.__array(1, 128), XrActionSetCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTIONSETNAME = layout.offsetof(2);
        LOCALIZEDACTIONSETNAME = layout.offsetof(3);
        PRIORITY = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrActionSetCreateInfo, Buffer>
    implements NativeResource {
        private static final XrActionSetCreateInfo ELEMENT_FACTORY = XrActionSetCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrActionSetCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionSetCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrActionSetCreateInfo.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]")
        public ByteBuffer actionSetName() {
            return XrActionSetCreateInfo.nactionSetName(this.address());
        }

        @NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]")
        public String actionSetNameString() {
            return XrActionSetCreateInfo.nactionSetNameString(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]")
        public ByteBuffer localizedActionSetName() {
            return XrActionSetCreateInfo.nlocalizedActionSetName(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]")
        public String localizedActionSetNameString() {
            return XrActionSetCreateInfo.nlocalizedActionSetNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int priority() {
            return XrActionSetCreateInfo.npriority(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionSetCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(28);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrActionSetCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer actionSetName(@NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]") ByteBuffer value) {
            XrActionSetCreateInfo.nactionSetName(this.address(), value);
            return this;
        }

        public Buffer localizedActionSetName(@NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]") ByteBuffer value) {
            XrActionSetCreateInfo.nlocalizedActionSetName(this.address(), value);
            return this;
        }

        public Buffer priority(@NativeType(value="uint32_t") int value) {
            XrActionSetCreateInfo.npriority(this.address(), value);
            return this;
        }
    }
}

