/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionSpaceCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;
    public static final int SUBACTIONPATH;
    public static final int POSEINACTIONSPACE;

    public XrActionSpaceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrActionSpaceCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionSpaceCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrActionSpaceCreateInfo.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrActionSpaceCreateInfo.naction(this.address());
    }

    @NativeType(value="XrPath")
    public long subactionPath() {
        return XrActionSpaceCreateInfo.nsubactionPath(this.address());
    }

    public XrPosef poseInActionSpace() {
        return XrActionSpaceCreateInfo.nposeInActionSpace(this.address());
    }

    public XrActionSpaceCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrActionSpaceCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrActionSpaceCreateInfo type$Default() {
        return this.type(38);
    }

    public XrActionSpaceCreateInfo next(@NativeType(value="void const *") long value) {
        XrActionSpaceCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrActionSpaceCreateInfo action(XrAction value) {
        XrActionSpaceCreateInfo.naction(this.address(), value);
        return this;
    }

    public XrActionSpaceCreateInfo subactionPath(@NativeType(value="XrPath") long value) {
        XrActionSpaceCreateInfo.nsubactionPath(this.address(), value);
        return this;
    }

    public XrActionSpaceCreateInfo poseInActionSpace(XrPosef value) {
        XrActionSpaceCreateInfo.nposeInActionSpace(this.address(), value);
        return this;
    }

    public XrActionSpaceCreateInfo poseInActionSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInActionSpace());
        return this;
    }

    public XrActionSpaceCreateInfo set(int type, long next, XrAction action, long subactionPath, XrPosef poseInActionSpace) {
        this.type(type);
        this.next(next);
        this.action(action);
        this.subactionPath(subactionPath);
        this.poseInActionSpace(poseInActionSpace);
        return this;
    }

    public XrActionSpaceCreateInfo set(XrActionSpaceCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrActionSpaceCreateInfo malloc() {
        return XrActionSpaceCreateInfo.wrap(XrActionSpaceCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrActionSpaceCreateInfo calloc() {
        return XrActionSpaceCreateInfo.wrap(XrActionSpaceCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrActionSpaceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrActionSpaceCreateInfo.wrap(XrActionSpaceCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static XrActionSpaceCreateInfo create(long address) {
        return XrActionSpaceCreateInfo.wrap(XrActionSpaceCreateInfo.class, address);
    }

    @Nullable
    public static XrActionSpaceCreateInfo createSafe(long address) {
        return address == 0L ? null : XrActionSpaceCreateInfo.wrap(XrActionSpaceCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrActionSpaceCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrActionSpaceCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrActionSpaceCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionSpaceCreateInfo.__create(capacity, SIZEOF);
        return XrActionSpaceCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrActionSpaceCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrActionSpaceCreateInfo.wrap(Buffer.class, address, capacity);
    }

    public static XrActionSpaceCreateInfo malloc(MemoryStack stack) {
        return XrActionSpaceCreateInfo.wrap(XrActionSpaceCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrActionSpaceCreateInfo calloc(MemoryStack stack) {
        return XrActionSpaceCreateInfo.wrap(XrActionSpaceCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrActionSpaceCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrActionSpaceCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ACTION);
    }

    public static long nsubactionPath(long struct) {
        return UNSAFE.getLong(null, struct + (long)SUBACTIONPATH);
    }

    public static XrPosef nposeInActionSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINACTIONSPACE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress(struct + (long)ACTION, value.address());
    }

    public static void nsubactionPath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SUBACTIONPATH, value);
    }

    public static void nposeInActionSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINACTIONSPACE, XrPosef.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ACTION));
    }

    static {
        Struct.Layout layout = XrActionSpaceCreateInfo.__struct(XrActionSpaceCreateInfo.__member(4), XrActionSpaceCreateInfo.__member(POINTER_SIZE), XrActionSpaceCreateInfo.__member(POINTER_SIZE), XrActionSpaceCreateInfo.__member(8), XrActionSpaceCreateInfo.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
        SUBACTIONPATH = layout.offsetof(3);
        POSEINACTIONSPACE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrActionSpaceCreateInfo, Buffer>
    implements NativeResource {
        private static final XrActionSpaceCreateInfo ELEMENT_FACTORY = XrActionSpaceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrActionSpaceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionSpaceCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrActionSpaceCreateInfo.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrActionSpaceCreateInfo.naction(this.address());
        }

        @NativeType(value="XrPath")
        public long subactionPath() {
            return XrActionSpaceCreateInfo.nsubactionPath(this.address());
        }

        public XrPosef poseInActionSpace() {
            return XrActionSpaceCreateInfo.nposeInActionSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionSpaceCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(38);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrActionSpaceCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrActionSpaceCreateInfo.naction(this.address(), value);
            return this;
        }

        public Buffer subactionPath(@NativeType(value="XrPath") long value) {
            XrActionSpaceCreateInfo.nsubactionPath(this.address(), value);
            return this;
        }

        public Buffer poseInActionSpace(XrPosef value) {
            XrActionSpaceCreateInfo.nposeInActionSpace(this.address(), value);
            return this;
        }

        public Buffer poseInActionSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInActionSpace());
            return this;
        }
    }
}

