/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBaseOutStructure
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrBaseOutStructure(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBaseOutStructure.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBaseOutStructure.ntype(this.address());
    }

    @NativeType(value="XrBaseOutStructure *")
    public XrBaseOutStructure next() {
        return XrBaseOutStructure.nnext(this.address());
    }

    public XrBaseOutStructure type(@NativeType(value="XrStructureType") int value) {
        XrBaseOutStructure.ntype(this.address(), value);
        return this;
    }

    public XrBaseOutStructure next(@NativeType(value="XrBaseOutStructure *") XrBaseOutStructure value) {
        XrBaseOutStructure.nnext(this.address(), value);
        return this;
    }

    public XrBaseOutStructure set(int type, XrBaseOutStructure next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrBaseOutStructure set(XrBaseOutStructure src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBaseOutStructure malloc() {
        return XrBaseOutStructure.wrap(XrBaseOutStructure.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrBaseOutStructure calloc() {
        return XrBaseOutStructure.wrap(XrBaseOutStructure.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrBaseOutStructure create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrBaseOutStructure.wrap(XrBaseOutStructure.class, MemoryUtil.memAddress(container), container);
    }

    public static XrBaseOutStructure create(long address) {
        return XrBaseOutStructure.wrap(XrBaseOutStructure.class, address);
    }

    @Nullable
    public static XrBaseOutStructure createSafe(long address) {
        return address == 0L ? null : XrBaseOutStructure.wrap(XrBaseOutStructure.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrBaseOutStructure.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrBaseOutStructure.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrBaseOutStructure.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBaseOutStructure.__create(capacity, SIZEOF);
        return XrBaseOutStructure.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrBaseOutStructure.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrBaseOutStructure.wrap(Buffer.class, address, capacity);
    }

    public static XrBaseOutStructure malloc(MemoryStack stack) {
        return XrBaseOutStructure.wrap(XrBaseOutStructure.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrBaseOutStructure calloc(MemoryStack stack) {
        return XrBaseOutStructure.wrap(XrBaseOutStructure.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrBaseOutStructure.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrBaseOutStructure.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static XrBaseOutStructure nnext(long struct) {
        return XrBaseOutStructure.create(MemoryUtil.memGetAddress(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, XrBaseOutStructure value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NEXT));
    }

    static {
        Struct.Layout layout = XrBaseOutStructure.__struct(XrBaseOutStructure.__member(4), XrBaseOutStructure.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBaseOutStructure, Buffer>
    implements NativeResource {
        private static final XrBaseOutStructure ELEMENT_FACTORY = XrBaseOutStructure.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrBaseOutStructure getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBaseOutStructure.ntype(this.address());
        }

        @NativeType(value="XrBaseOutStructure *")
        public XrBaseOutStructure next() {
            return XrBaseOutStructure.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBaseOutStructure.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="XrBaseOutStructure *") XrBaseOutStructure value) {
            XrBaseOutStructure.nnext(this.address(), value);
            return this;
        }
    }
}

