/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrDebugUtilsLabelEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LABELNAME;

    public XrDebugUtilsLabelEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrDebugUtilsLabelEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrDebugUtilsLabelEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrDebugUtilsLabelEXT.nnext(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer labelName() {
        return XrDebugUtilsLabelEXT.nlabelName(this.address());
    }

    @NativeType(value="char const *")
    public String labelNameString() {
        return XrDebugUtilsLabelEXT.nlabelNameString(this.address());
    }

    public XrDebugUtilsLabelEXT type(@NativeType(value="XrStructureType") int value) {
        XrDebugUtilsLabelEXT.ntype(this.address(), value);
        return this;
    }

    public XrDebugUtilsLabelEXT type$Default() {
        return this.type(1000019003);
    }

    public XrDebugUtilsLabelEXT next(@NativeType(value="void const *") long value) {
        XrDebugUtilsLabelEXT.nnext(this.address(), value);
        return this;
    }

    public XrDebugUtilsLabelEXT labelName(@NativeType(value="char const *") ByteBuffer value) {
        XrDebugUtilsLabelEXT.nlabelName(this.address(), value);
        return this;
    }

    public XrDebugUtilsLabelEXT set(int type, long next, ByteBuffer labelName) {
        this.type(type);
        this.next(next);
        this.labelName(labelName);
        return this;
    }

    public XrDebugUtilsLabelEXT set(XrDebugUtilsLabelEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrDebugUtilsLabelEXT malloc() {
        return XrDebugUtilsLabelEXT.wrap(XrDebugUtilsLabelEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrDebugUtilsLabelEXT calloc() {
        return XrDebugUtilsLabelEXT.wrap(XrDebugUtilsLabelEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrDebugUtilsLabelEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrDebugUtilsLabelEXT.wrap(XrDebugUtilsLabelEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrDebugUtilsLabelEXT create(long address) {
        return XrDebugUtilsLabelEXT.wrap(XrDebugUtilsLabelEXT.class, address);
    }

    @Nullable
    public static XrDebugUtilsLabelEXT createSafe(long address) {
        return address == 0L ? null : XrDebugUtilsLabelEXT.wrap(XrDebugUtilsLabelEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrDebugUtilsLabelEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrDebugUtilsLabelEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrDebugUtilsLabelEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrDebugUtilsLabelEXT.__create(capacity, SIZEOF);
        return XrDebugUtilsLabelEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrDebugUtilsLabelEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrDebugUtilsLabelEXT.wrap(Buffer.class, address, capacity);
    }

    public static XrDebugUtilsLabelEXT malloc(MemoryStack stack) {
        return XrDebugUtilsLabelEXT.wrap(XrDebugUtilsLabelEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrDebugUtilsLabelEXT calloc(MemoryStack stack) {
        return XrDebugUtilsLabelEXT.wrap(XrDebugUtilsLabelEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrDebugUtilsLabelEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrDebugUtilsLabelEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static ByteBuffer nlabelName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)LABELNAME));
    }

    public static String nlabelNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)LABELNAME));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlabelName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)LABELNAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)LABELNAME));
    }

    static {
        Struct.Layout layout = XrDebugUtilsLabelEXT.__struct(XrDebugUtilsLabelEXT.__member(4), XrDebugUtilsLabelEXT.__member(POINTER_SIZE), XrDebugUtilsLabelEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LABELNAME = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrDebugUtilsLabelEXT, Buffer>
    implements NativeResource {
        private static final XrDebugUtilsLabelEXT ELEMENT_FACTORY = XrDebugUtilsLabelEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrDebugUtilsLabelEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrDebugUtilsLabelEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrDebugUtilsLabelEXT.nnext(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer labelName() {
            return XrDebugUtilsLabelEXT.nlabelName(this.address());
        }

        @NativeType(value="char const *")
        public String labelNameString() {
            return XrDebugUtilsLabelEXT.nlabelNameString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrDebugUtilsLabelEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000019003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrDebugUtilsLabelEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer labelName(@NativeType(value="char const *") ByteBuffer value) {
            XrDebugUtilsLabelEXT.nlabelName(this.address(), value);
            return this;
        }
    }
}

