/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrDebugUtilsObjectNameInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int OBJECTTYPE;
    public static final int OBJECTHANDLE;
    public static final int OBJECTNAME;

    public XrDebugUtilsObjectNameInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrDebugUtilsObjectNameInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrDebugUtilsObjectNameInfoEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrDebugUtilsObjectNameInfoEXT.nnext(this.address());
    }

    @NativeType(value="XrObjectType")
    public int objectType() {
        return XrDebugUtilsObjectNameInfoEXT.nobjectType(this.address());
    }

    @NativeType(value="uint64_t")
    public long objectHandle() {
        return XrDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer objectName() {
        return XrDebugUtilsObjectNameInfoEXT.nobjectName(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String objectNameString() {
        return XrDebugUtilsObjectNameInfoEXT.nobjectNameString(this.address());
    }

    public XrDebugUtilsObjectNameInfoEXT type(@NativeType(value="XrStructureType") int value) {
        XrDebugUtilsObjectNameInfoEXT.ntype(this.address(), value);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT type$Default() {
        return this.type(1000019000);
    }

    public XrDebugUtilsObjectNameInfoEXT next(@NativeType(value="void const *") long value) {
        XrDebugUtilsObjectNameInfoEXT.nnext(this.address(), value);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT objectType(@NativeType(value="XrObjectType") int value) {
        XrDebugUtilsObjectNameInfoEXT.nobjectType(this.address(), value);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT objectHandle(@NativeType(value="uint64_t") long value) {
        XrDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address(), value);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT objectName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
        XrDebugUtilsObjectNameInfoEXT.nobjectName(this.address(), value);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT set(int type, long next, int objectType, long objectHandle, @Nullable ByteBuffer objectName) {
        this.type(type);
        this.next(next);
        this.objectType(objectType);
        this.objectHandle(objectHandle);
        this.objectName(objectName);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT set(XrDebugUtilsObjectNameInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrDebugUtilsObjectNameInfoEXT malloc() {
        return XrDebugUtilsObjectNameInfoEXT.wrap(XrDebugUtilsObjectNameInfoEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrDebugUtilsObjectNameInfoEXT calloc() {
        return XrDebugUtilsObjectNameInfoEXT.wrap(XrDebugUtilsObjectNameInfoEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrDebugUtilsObjectNameInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrDebugUtilsObjectNameInfoEXT.wrap(XrDebugUtilsObjectNameInfoEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrDebugUtilsObjectNameInfoEXT create(long address) {
        return XrDebugUtilsObjectNameInfoEXT.wrap(XrDebugUtilsObjectNameInfoEXT.class, address);
    }

    @Nullable
    public static XrDebugUtilsObjectNameInfoEXT createSafe(long address) {
        return address == 0L ? null : XrDebugUtilsObjectNameInfoEXT.wrap(XrDebugUtilsObjectNameInfoEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrDebugUtilsObjectNameInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrDebugUtilsObjectNameInfoEXT.__create(capacity, SIZEOF);
        return XrDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, address, capacity);
    }

    public static XrDebugUtilsObjectNameInfoEXT malloc(MemoryStack stack) {
        return XrDebugUtilsObjectNameInfoEXT.wrap(XrDebugUtilsObjectNameInfoEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrDebugUtilsObjectNameInfoEXT calloc(MemoryStack stack) {
        return XrDebugUtilsObjectNameInfoEXT.wrap(XrDebugUtilsObjectNameInfoEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nobjectType(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTTYPE);
    }

    public static long nobjectHandle(long struct) {
        return UNSAFE.getLong(null, struct + (long)OBJECTHANDLE);
    }

    @Nullable
    public static ByteBuffer nobjectName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)OBJECTNAME));
    }

    @Nullable
    public static String nobjectNameString(long struct) {
        return MemoryUtil.memUTF8Safe(MemoryUtil.memGetAddress(struct + (long)OBJECTNAME));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nobjectType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTTYPE, value);
    }

    public static void nobjectHandle(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OBJECTHANDLE, value);
    }

    public static void nobjectName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)OBJECTNAME, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = XrDebugUtilsObjectNameInfoEXT.__struct(XrDebugUtilsObjectNameInfoEXT.__member(4), XrDebugUtilsObjectNameInfoEXT.__member(POINTER_SIZE), XrDebugUtilsObjectNameInfoEXT.__member(4), XrDebugUtilsObjectNameInfoEXT.__member(8), XrDebugUtilsObjectNameInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        OBJECTTYPE = layout.offsetof(2);
        OBJECTHANDLE = layout.offsetof(3);
        OBJECTNAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrDebugUtilsObjectNameInfoEXT, Buffer>
    implements NativeResource {
        private static final XrDebugUtilsObjectNameInfoEXT ELEMENT_FACTORY = XrDebugUtilsObjectNameInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrDebugUtilsObjectNameInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrDebugUtilsObjectNameInfoEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrDebugUtilsObjectNameInfoEXT.nnext(this.address());
        }

        @NativeType(value="XrObjectType")
        public int objectType() {
            return XrDebugUtilsObjectNameInfoEXT.nobjectType(this.address());
        }

        @NativeType(value="uint64_t")
        public long objectHandle() {
            return XrDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer objectName() {
            return XrDebugUtilsObjectNameInfoEXT.nobjectName(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String objectNameString() {
            return XrDebugUtilsObjectNameInfoEXT.nobjectNameString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrDebugUtilsObjectNameInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000019000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrDebugUtilsObjectNameInfoEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer objectType(@NativeType(value="XrObjectType") int value) {
            XrDebugUtilsObjectNameInfoEXT.nobjectType(this.address(), value);
            return this;
        }

        public Buffer objectHandle(@NativeType(value="uint64_t") long value) {
            XrDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address(), value);
            return this;
        }

        public Buffer objectName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
            XrDebugUtilsObjectNameInfoEXT.nobjectName(this.address(), value);
            return this;
        }
    }
}

