/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEventDataBaseHeader;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataEventsLost
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOSTEVENTCOUNT;

    public XrEventDataEventsLost(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEventDataEventsLost.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataEventsLost.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataEventsLost.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int lostEventCount() {
        return XrEventDataEventsLost.nlostEventCount(this.address());
    }

    public XrEventDataEventsLost type(@NativeType(value="XrStructureType") int value) {
        XrEventDataEventsLost.ntype(this.address(), value);
        return this;
    }

    public XrEventDataEventsLost type$Default() {
        return this.type(49);
    }

    public XrEventDataEventsLost next(@NativeType(value="void const *") long value) {
        XrEventDataEventsLost.nnext(this.address(), value);
        return this;
    }

    public XrEventDataEventsLost lostEventCount(@NativeType(value="uint32_t") int value) {
        XrEventDataEventsLost.nlostEventCount(this.address(), value);
        return this;
    }

    public XrEventDataEventsLost set(int type, long next, int lostEventCount) {
        this.type(type);
        this.next(next);
        this.lostEventCount(lostEventCount);
        return this;
    }

    public XrEventDataEventsLost set(XrEventDataEventsLost src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEventDataEventsLost malloc() {
        return XrEventDataEventsLost.wrap(XrEventDataEventsLost.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrEventDataEventsLost calloc() {
        return XrEventDataEventsLost.wrap(XrEventDataEventsLost.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrEventDataEventsLost create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrEventDataEventsLost.wrap(XrEventDataEventsLost.class, MemoryUtil.memAddress(container), container);
    }

    public static XrEventDataEventsLost create(long address) {
        return XrEventDataEventsLost.wrap(XrEventDataEventsLost.class, address);
    }

    @Nullable
    public static XrEventDataEventsLost createSafe(long address) {
        return address == 0L ? null : XrEventDataEventsLost.wrap(XrEventDataEventsLost.class, address);
    }

    public static XrEventDataEventsLost create(XrEventDataBaseHeader value) {
        return XrEventDataEventsLost.wrap(XrEventDataEventsLost.class, value);
    }

    public static Buffer malloc(int capacity) {
        return XrEventDataEventsLost.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrEventDataEventsLost.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrEventDataEventsLost.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataEventsLost.__create(capacity, SIZEOF);
        return XrEventDataEventsLost.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrEventDataEventsLost.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrEventDataEventsLost.wrap(Buffer.class, address, capacity);
    }

    public static Buffer create(XrEventDataBaseHeader.Buffer value) {
        return XrEventDataEventsLost.wrap(Buffer.class, value);
    }

    public static XrEventDataEventsLost malloc(MemoryStack stack) {
        return XrEventDataEventsLost.wrap(XrEventDataEventsLost.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrEventDataEventsLost calloc(MemoryStack stack) {
        return XrEventDataEventsLost.wrap(XrEventDataEventsLost.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrEventDataEventsLost.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrEventDataEventsLost.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nlostEventCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOSTEVENTCOUNT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlostEventCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOSTEVENTCOUNT, value);
    }

    static {
        Struct.Layout layout = XrEventDataEventsLost.__struct(XrEventDataEventsLost.__member(4), XrEventDataEventsLost.__member(POINTER_SIZE), XrEventDataEventsLost.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOSTEVENTCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataEventsLost, Buffer>
    implements NativeResource {
        private static final XrEventDataEventsLost ELEMENT_FACTORY = XrEventDataEventsLost.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrEventDataEventsLost getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataEventsLost.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataEventsLost.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int lostEventCount() {
            return XrEventDataEventsLost.nlostEventCount(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataEventsLost.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(49);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataEventsLost.nnext(this.address(), value);
            return this;
        }

        public Buffer lostEventCount(@NativeType(value="uint32_t") int value) {
            XrEventDataEventsLost.nlostEventCount(this.address(), value);
            return this;
        }
    }
}

