/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEventDataBaseHeader;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataInstanceLossPending
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOSSTIME;

    public XrEventDataInstanceLossPending(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEventDataInstanceLossPending.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataInstanceLossPending.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataInstanceLossPending.nnext(this.address());
    }

    @NativeType(value="XrTime")
    public long lossTime() {
        return XrEventDataInstanceLossPending.nlossTime(this.address());
    }

    public XrEventDataInstanceLossPending type(@NativeType(value="XrStructureType") int value) {
        XrEventDataInstanceLossPending.ntype(this.address(), value);
        return this;
    }

    public XrEventDataInstanceLossPending type$Default() {
        return this.type(17);
    }

    public XrEventDataInstanceLossPending next(@NativeType(value="void const *") long value) {
        XrEventDataInstanceLossPending.nnext(this.address(), value);
        return this;
    }

    public XrEventDataInstanceLossPending lossTime(@NativeType(value="XrTime") long value) {
        XrEventDataInstanceLossPending.nlossTime(this.address(), value);
        return this;
    }

    public XrEventDataInstanceLossPending set(int type, long next, long lossTime) {
        this.type(type);
        this.next(next);
        this.lossTime(lossTime);
        return this;
    }

    public XrEventDataInstanceLossPending set(XrEventDataInstanceLossPending src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEventDataInstanceLossPending malloc() {
        return XrEventDataInstanceLossPending.wrap(XrEventDataInstanceLossPending.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrEventDataInstanceLossPending calloc() {
        return XrEventDataInstanceLossPending.wrap(XrEventDataInstanceLossPending.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrEventDataInstanceLossPending create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrEventDataInstanceLossPending.wrap(XrEventDataInstanceLossPending.class, MemoryUtil.memAddress(container), container);
    }

    public static XrEventDataInstanceLossPending create(long address) {
        return XrEventDataInstanceLossPending.wrap(XrEventDataInstanceLossPending.class, address);
    }

    @Nullable
    public static XrEventDataInstanceLossPending createSafe(long address) {
        return address == 0L ? null : XrEventDataInstanceLossPending.wrap(XrEventDataInstanceLossPending.class, address);
    }

    public static XrEventDataInstanceLossPending create(XrEventDataBaseHeader value) {
        return XrEventDataInstanceLossPending.wrap(XrEventDataInstanceLossPending.class, value);
    }

    public static Buffer malloc(int capacity) {
        return XrEventDataInstanceLossPending.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrEventDataInstanceLossPending.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrEventDataInstanceLossPending.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataInstanceLossPending.__create(capacity, SIZEOF);
        return XrEventDataInstanceLossPending.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrEventDataInstanceLossPending.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrEventDataInstanceLossPending.wrap(Buffer.class, address, capacity);
    }

    public static Buffer create(XrEventDataBaseHeader.Buffer value) {
        return XrEventDataInstanceLossPending.wrap(Buffer.class, value);
    }

    public static XrEventDataInstanceLossPending malloc(MemoryStack stack) {
        return XrEventDataInstanceLossPending.wrap(XrEventDataInstanceLossPending.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrEventDataInstanceLossPending calloc(MemoryStack stack) {
        return XrEventDataInstanceLossPending.wrap(XrEventDataInstanceLossPending.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrEventDataInstanceLossPending.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrEventDataInstanceLossPending.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nlossTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)LOSSTIME);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlossTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LOSSTIME, value);
    }

    static {
        Struct.Layout layout = XrEventDataInstanceLossPending.__struct(XrEventDataInstanceLossPending.__member(4), XrEventDataInstanceLossPending.__member(POINTER_SIZE), XrEventDataInstanceLossPending.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOSSTIME = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataInstanceLossPending, Buffer>
    implements NativeResource {
        private static final XrEventDataInstanceLossPending ELEMENT_FACTORY = XrEventDataInstanceLossPending.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrEventDataInstanceLossPending getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataInstanceLossPending.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataInstanceLossPending.nnext(this.address());
        }

        @NativeType(value="XrTime")
        public long lossTime() {
            return XrEventDataInstanceLossPending.nlossTime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataInstanceLossPending.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(17);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataInstanceLossPending.nnext(this.address(), value);
            return this;
        }

        public Buffer lossTime(@NativeType(value="XrTime") long value) {
            XrEventDataInstanceLossPending.nlossTime(this.address(), value);
            return this;
        }
    }
}

