/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEventDataBaseHeader;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataVisibilityMaskChangedKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SESSION;
    public static final int VIEWCONFIGURATIONTYPE;
    public static final int VIEWINDEX;

    public XrEventDataVisibilityMaskChangedKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEventDataVisibilityMaskChangedKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataVisibilityMaskChangedKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataVisibilityMaskChangedKHR.nnext(this.address());
    }

    @NativeType(value="XrSession")
    public long session() {
        return XrEventDataVisibilityMaskChangedKHR.nsession(this.address());
    }

    @NativeType(value="XrViewConfigurationType")
    public int viewConfigurationType() {
        return XrEventDataVisibilityMaskChangedKHR.nviewConfigurationType(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewIndex() {
        return XrEventDataVisibilityMaskChangedKHR.nviewIndex(this.address());
    }

    public XrEventDataVisibilityMaskChangedKHR type(@NativeType(value="XrStructureType") int value) {
        XrEventDataVisibilityMaskChangedKHR.ntype(this.address(), value);
        return this;
    }

    public XrEventDataVisibilityMaskChangedKHR type$Default() {
        return this.type(1000031001);
    }

    public XrEventDataVisibilityMaskChangedKHR next(@NativeType(value="void const *") long value) {
        XrEventDataVisibilityMaskChangedKHR.nnext(this.address(), value);
        return this;
    }

    public XrEventDataVisibilityMaskChangedKHR session(XrSession value) {
        XrEventDataVisibilityMaskChangedKHR.nsession(this.address(), value);
        return this;
    }

    public XrEventDataVisibilityMaskChangedKHR viewConfigurationType(@NativeType(value="XrViewConfigurationType") int value) {
        XrEventDataVisibilityMaskChangedKHR.nviewConfigurationType(this.address(), value);
        return this;
    }

    public XrEventDataVisibilityMaskChangedKHR viewIndex(@NativeType(value="uint32_t") int value) {
        XrEventDataVisibilityMaskChangedKHR.nviewIndex(this.address(), value);
        return this;
    }

    public XrEventDataVisibilityMaskChangedKHR set(int type, long next, XrSession session, int viewConfigurationType, int viewIndex) {
        this.type(type);
        this.next(next);
        this.session(session);
        this.viewConfigurationType(viewConfigurationType);
        this.viewIndex(viewIndex);
        return this;
    }

    public XrEventDataVisibilityMaskChangedKHR set(XrEventDataVisibilityMaskChangedKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEventDataVisibilityMaskChangedKHR malloc() {
        return XrEventDataVisibilityMaskChangedKHR.wrap(XrEventDataVisibilityMaskChangedKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrEventDataVisibilityMaskChangedKHR calloc() {
        return XrEventDataVisibilityMaskChangedKHR.wrap(XrEventDataVisibilityMaskChangedKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrEventDataVisibilityMaskChangedKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrEventDataVisibilityMaskChangedKHR.wrap(XrEventDataVisibilityMaskChangedKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrEventDataVisibilityMaskChangedKHR create(long address) {
        return XrEventDataVisibilityMaskChangedKHR.wrap(XrEventDataVisibilityMaskChangedKHR.class, address);
    }

    @Nullable
    public static XrEventDataVisibilityMaskChangedKHR createSafe(long address) {
        return address == 0L ? null : XrEventDataVisibilityMaskChangedKHR.wrap(XrEventDataVisibilityMaskChangedKHR.class, address);
    }

    public static XrEventDataVisibilityMaskChangedKHR create(XrEventDataBaseHeader value) {
        return XrEventDataVisibilityMaskChangedKHR.wrap(XrEventDataVisibilityMaskChangedKHR.class, value);
    }

    public static Buffer malloc(int capacity) {
        return XrEventDataVisibilityMaskChangedKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrEventDataVisibilityMaskChangedKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrEventDataVisibilityMaskChangedKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataVisibilityMaskChangedKHR.__create(capacity, SIZEOF);
        return XrEventDataVisibilityMaskChangedKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrEventDataVisibilityMaskChangedKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrEventDataVisibilityMaskChangedKHR.wrap(Buffer.class, address, capacity);
    }

    public static Buffer create(XrEventDataBaseHeader.Buffer value) {
        return XrEventDataVisibilityMaskChangedKHR.wrap(Buffer.class, value);
    }

    public static XrEventDataVisibilityMaskChangedKHR malloc(MemoryStack stack) {
        return XrEventDataVisibilityMaskChangedKHR.wrap(XrEventDataVisibilityMaskChangedKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrEventDataVisibilityMaskChangedKHR calloc(MemoryStack stack) {
        return XrEventDataVisibilityMaskChangedKHR.wrap(XrEventDataVisibilityMaskChangedKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrEventDataVisibilityMaskChangedKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrEventDataVisibilityMaskChangedKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nsession(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SESSION);
    }

    public static int nviewConfigurationType(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWCONFIGURATIONTYPE);
    }

    public static int nviewIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWINDEX);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsession(long struct, XrSession value) {
        MemoryUtil.memPutAddress(struct + (long)SESSION, value.address());
    }

    public static void nviewConfigurationType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWCONFIGURATIONTYPE, value);
    }

    public static void nviewIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWINDEX, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SESSION));
    }

    static {
        Struct.Layout layout = XrEventDataVisibilityMaskChangedKHR.__struct(XrEventDataVisibilityMaskChangedKHR.__member(4), XrEventDataVisibilityMaskChangedKHR.__member(POINTER_SIZE), XrEventDataVisibilityMaskChangedKHR.__member(POINTER_SIZE), XrEventDataVisibilityMaskChangedKHR.__member(4), XrEventDataVisibilityMaskChangedKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SESSION = layout.offsetof(2);
        VIEWCONFIGURATIONTYPE = layout.offsetof(3);
        VIEWINDEX = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataVisibilityMaskChangedKHR, Buffer>
    implements NativeResource {
        private static final XrEventDataVisibilityMaskChangedKHR ELEMENT_FACTORY = XrEventDataVisibilityMaskChangedKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrEventDataVisibilityMaskChangedKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataVisibilityMaskChangedKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataVisibilityMaskChangedKHR.nnext(this.address());
        }

        @NativeType(value="XrSession")
        public long session() {
            return XrEventDataVisibilityMaskChangedKHR.nsession(this.address());
        }

        @NativeType(value="XrViewConfigurationType")
        public int viewConfigurationType() {
            return XrEventDataVisibilityMaskChangedKHR.nviewConfigurationType(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewIndex() {
            return XrEventDataVisibilityMaskChangedKHR.nviewIndex(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataVisibilityMaskChangedKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000031001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataVisibilityMaskChangedKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer session(XrSession value) {
            XrEventDataVisibilityMaskChangedKHR.nsession(this.address(), value);
            return this;
        }

        public Buffer viewConfigurationType(@NativeType(value="XrViewConfigurationType") int value) {
            XrEventDataVisibilityMaskChangedKHR.nviewConfigurationType(this.address(), value);
            return this;
        }

        public Buffer viewIndex(@NativeType(value="uint32_t") int value) {
            XrEventDataVisibilityMaskChangedKHR.nviewIndex(this.address(), value);
            return this;
        }
    }
}

