/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtent2Df
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    public XrExtent2Df(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrExtent2Df.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float width() {
        return XrExtent2Df.nwidth(this.address());
    }

    public float height() {
        return XrExtent2Df.nheight(this.address());
    }

    public XrExtent2Df width(float value) {
        XrExtent2Df.nwidth(this.address(), value);
        return this;
    }

    public XrExtent2Df height(float value) {
        XrExtent2Df.nheight(this.address(), value);
        return this;
    }

    public XrExtent2Df set(float width, float height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public XrExtent2Df set(XrExtent2Df src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrExtent2Df malloc() {
        return XrExtent2Df.wrap(XrExtent2Df.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrExtent2Df calloc() {
        return XrExtent2Df.wrap(XrExtent2Df.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrExtent2Df create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrExtent2Df.wrap(XrExtent2Df.class, MemoryUtil.memAddress(container), container);
    }

    public static XrExtent2Df create(long address) {
        return XrExtent2Df.wrap(XrExtent2Df.class, address);
    }

    @Nullable
    public static XrExtent2Df createSafe(long address) {
        return address == 0L ? null : XrExtent2Df.wrap(XrExtent2Df.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrExtent2Df.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrExtent2Df.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrExtent2Df.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtent2Df.__create(capacity, SIZEOF);
        return XrExtent2Df.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrExtent2Df.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrExtent2Df.wrap(Buffer.class, address, capacity);
    }

    public static XrExtent2Df malloc(MemoryStack stack) {
        return XrExtent2Df.wrap(XrExtent2Df.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrExtent2Df calloc(MemoryStack stack) {
        return XrExtent2Df.wrap(XrExtent2Df.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrExtent2Df.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrExtent2Df.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = XrExtent2Df.__struct(XrExtent2Df.__member(4), XrExtent2Df.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrExtent2Df, Buffer>
    implements NativeResource {
        private static final XrExtent2Df ELEMENT_FACTORY = XrExtent2Df.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrExtent2Df getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float width() {
            return XrExtent2Df.nwidth(this.address());
        }

        public float height() {
            return XrExtent2Df.nheight(this.address());
        }

        public Buffer width(float value) {
            XrExtent2Df.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            XrExtent2Df.nheight(this.address(), value);
            return this;
        }
    }
}

