/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFacialExpressionsHTC
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ISACTIVE;
    public static final int SAMPLETIME;
    public static final int EXPRESSIONCOUNT;
    public static final int EXPRESSIONWEIGHTINGS;

    public XrFacialExpressionsHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrFacialExpressionsHTC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFacialExpressionsHTC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFacialExpressionsHTC.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrFacialExpressionsHTC.nisActive(this.address()) != 0;
    }

    @NativeType(value="XrTime")
    public long sampleTime() {
        return XrFacialExpressionsHTC.nsampleTime(this.address());
    }

    @NativeType(value="uint32_t")
    public int expressionCount() {
        return XrFacialExpressionsHTC.nexpressionCount(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer expressionWeightings(int capacity) {
        return XrFacialExpressionsHTC.nexpressionWeightings(this.address(), capacity);
    }

    public XrFacialExpressionsHTC type(@NativeType(value="XrStructureType") int value) {
        XrFacialExpressionsHTC.ntype(this.address(), value);
        return this;
    }

    public XrFacialExpressionsHTC type$Default() {
        return this.type(1000104002);
    }

    public XrFacialExpressionsHTC next(@NativeType(value="void const *") long value) {
        XrFacialExpressionsHTC.nnext(this.address(), value);
        return this;
    }

    public XrFacialExpressionsHTC isActive(@NativeType(value="XrBool32") boolean value) {
        XrFacialExpressionsHTC.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrFacialExpressionsHTC sampleTime(@NativeType(value="XrTime") long value) {
        XrFacialExpressionsHTC.nsampleTime(this.address(), value);
        return this;
    }

    public XrFacialExpressionsHTC expressionCount(@NativeType(value="uint32_t") int value) {
        XrFacialExpressionsHTC.nexpressionCount(this.address(), value);
        return this;
    }

    public XrFacialExpressionsHTC expressionWeightings(@NativeType(value="float *") FloatBuffer value) {
        XrFacialExpressionsHTC.nexpressionWeightings(this.address(), value);
        return this;
    }

    public XrFacialExpressionsHTC set(int type, long next, boolean isActive, long sampleTime, int expressionCount, FloatBuffer expressionWeightings) {
        this.type(type);
        this.next(next);
        this.isActive(isActive);
        this.sampleTime(sampleTime);
        this.expressionCount(expressionCount);
        this.expressionWeightings(expressionWeightings);
        return this;
    }

    public XrFacialExpressionsHTC set(XrFacialExpressionsHTC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFacialExpressionsHTC malloc() {
        return XrFacialExpressionsHTC.wrap(XrFacialExpressionsHTC.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrFacialExpressionsHTC calloc() {
        return XrFacialExpressionsHTC.wrap(XrFacialExpressionsHTC.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrFacialExpressionsHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrFacialExpressionsHTC.wrap(XrFacialExpressionsHTC.class, MemoryUtil.memAddress(container), container);
    }

    public static XrFacialExpressionsHTC create(long address) {
        return XrFacialExpressionsHTC.wrap(XrFacialExpressionsHTC.class, address);
    }

    @Nullable
    public static XrFacialExpressionsHTC createSafe(long address) {
        return address == 0L ? null : XrFacialExpressionsHTC.wrap(XrFacialExpressionsHTC.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrFacialExpressionsHTC.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrFacialExpressionsHTC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrFacialExpressionsHTC.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFacialExpressionsHTC.__create(capacity, SIZEOF);
        return XrFacialExpressionsHTC.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrFacialExpressionsHTC.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrFacialExpressionsHTC.wrap(Buffer.class, address, capacity);
    }

    public static XrFacialExpressionsHTC malloc(MemoryStack stack) {
        return XrFacialExpressionsHTC.wrap(XrFacialExpressionsHTC.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrFacialExpressionsHTC calloc(MemoryStack stack) {
        return XrFacialExpressionsHTC.wrap(XrFacialExpressionsHTC.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrFacialExpressionsHTC.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrFacialExpressionsHTC.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nisActive(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISACTIVE);
    }

    public static long nsampleTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)SAMPLETIME);
    }

    public static int nexpressionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)EXPRESSIONCOUNT);
    }

    public static FloatBuffer nexpressionWeightings(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)EXPRESSIONWEIGHTINGS), capacity);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nisActive(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ISACTIVE, value);
    }

    public static void nsampleTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SAMPLETIME, value);
    }

    public static void nexpressionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EXPRESSIONCOUNT, value);
    }

    public static void nexpressionWeightings(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)EXPRESSIONWEIGHTINGS, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)EXPRESSIONWEIGHTINGS));
    }

    static {
        Struct.Layout layout = XrFacialExpressionsHTC.__struct(XrFacialExpressionsHTC.__member(4), XrFacialExpressionsHTC.__member(POINTER_SIZE), XrFacialExpressionsHTC.__member(4), XrFacialExpressionsHTC.__member(8), XrFacialExpressionsHTC.__member(4), XrFacialExpressionsHTC.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ISACTIVE = layout.offsetof(2);
        SAMPLETIME = layout.offsetof(3);
        EXPRESSIONCOUNT = layout.offsetof(4);
        EXPRESSIONWEIGHTINGS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrFacialExpressionsHTC, Buffer>
    implements NativeResource {
        private static final XrFacialExpressionsHTC ELEMENT_FACTORY = XrFacialExpressionsHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrFacialExpressionsHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFacialExpressionsHTC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFacialExpressionsHTC.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrFacialExpressionsHTC.nisActive(this.address()) != 0;
        }

        @NativeType(value="XrTime")
        public long sampleTime() {
            return XrFacialExpressionsHTC.nsampleTime(this.address());
        }

        @NativeType(value="uint32_t")
        public int expressionCount() {
            return XrFacialExpressionsHTC.nexpressionCount(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer expressionWeightings(int capacity) {
            return XrFacialExpressionsHTC.nexpressionWeightings(this.address(), capacity);
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFacialExpressionsHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000104002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFacialExpressionsHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrFacialExpressionsHTC.nisActive(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sampleTime(@NativeType(value="XrTime") long value) {
            XrFacialExpressionsHTC.nsampleTime(this.address(), value);
            return this;
        }

        public Buffer expressionCount(@NativeType(value="uint32_t") int value) {
            XrFacialExpressionsHTC.nexpressionCount(this.address(), value);
            return this;
        }

        public Buffer expressionWeightings(@NativeType(value="float *") FloatBuffer value) {
            XrFacialExpressionsHTC.nexpressionWeightings(this.address(), value);
            return this;
        }
    }
}

