/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFrameBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrFrameBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrFrameBeginInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFrameBeginInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFrameBeginInfo.nnext(this.address());
    }

    public XrFrameBeginInfo type(@NativeType(value="XrStructureType") int value) {
        XrFrameBeginInfo.ntype(this.address(), value);
        return this;
    }

    public XrFrameBeginInfo type$Default() {
        return this.type(46);
    }

    public XrFrameBeginInfo next(@NativeType(value="void const *") long value) {
        XrFrameBeginInfo.nnext(this.address(), value);
        return this;
    }

    public XrFrameBeginInfo set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrFrameBeginInfo set(XrFrameBeginInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFrameBeginInfo malloc() {
        return XrFrameBeginInfo.wrap(XrFrameBeginInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrFrameBeginInfo calloc() {
        return XrFrameBeginInfo.wrap(XrFrameBeginInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrFrameBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrFrameBeginInfo.wrap(XrFrameBeginInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static XrFrameBeginInfo create(long address) {
        return XrFrameBeginInfo.wrap(XrFrameBeginInfo.class, address);
    }

    @Nullable
    public static XrFrameBeginInfo createSafe(long address) {
        return address == 0L ? null : XrFrameBeginInfo.wrap(XrFrameBeginInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrFrameBeginInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrFrameBeginInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrFrameBeginInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFrameBeginInfo.__create(capacity, SIZEOF);
        return XrFrameBeginInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrFrameBeginInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrFrameBeginInfo.wrap(Buffer.class, address, capacity);
    }

    public static XrFrameBeginInfo malloc(MemoryStack stack) {
        return XrFrameBeginInfo.wrap(XrFrameBeginInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrFrameBeginInfo calloc(MemoryStack stack) {
        return XrFrameBeginInfo.wrap(XrFrameBeginInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrFrameBeginInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrFrameBeginInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrFrameBeginInfo.__struct(XrFrameBeginInfo.__member(4), XrFrameBeginInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrFrameBeginInfo, Buffer>
    implements NativeResource {
        private static final XrFrameBeginInfo ELEMENT_FACTORY = XrFrameBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrFrameBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFrameBeginInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFrameBeginInfo.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFrameBeginInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(46);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFrameBeginInfo.nnext(this.address(), value);
            return this;
        }
    }
}

