/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGraphicsBindingOpenGLWin32KHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int HDC;
    public static final int HGLRC;

    public XrGraphicsBindingOpenGLWin32KHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrGraphicsBindingOpenGLWin32KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsBindingOpenGLWin32KHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGraphicsBindingOpenGLWin32KHR.nnext(this.address());
    }

    @NativeType(value="HDC")
    public long hDC() {
        return XrGraphicsBindingOpenGLWin32KHR.nhDC(this.address());
    }

    @NativeType(value="HGLRC")
    public long hGLRC() {
        return XrGraphicsBindingOpenGLWin32KHR.nhGLRC(this.address());
    }

    public XrGraphicsBindingOpenGLWin32KHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsBindingOpenGLWin32KHR.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLWin32KHR type$Default() {
        return this.type(1000023000);
    }

    public XrGraphicsBindingOpenGLWin32KHR next(@NativeType(value="void const *") long value) {
        XrGraphicsBindingOpenGLWin32KHR.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLWin32KHR hDC(@NativeType(value="HDC") long value) {
        XrGraphicsBindingOpenGLWin32KHR.nhDC(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLWin32KHR hGLRC(@NativeType(value="HGLRC") long value) {
        XrGraphicsBindingOpenGLWin32KHR.nhGLRC(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLWin32KHR set(int type, long next, long hDC, long hGLRC) {
        this.type(type);
        this.next(next);
        this.hDC(hDC);
        this.hGLRC(hGLRC);
        return this;
    }

    public XrGraphicsBindingOpenGLWin32KHR set(XrGraphicsBindingOpenGLWin32KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrGraphicsBindingOpenGLWin32KHR malloc() {
        return XrGraphicsBindingOpenGLWin32KHR.wrap(XrGraphicsBindingOpenGLWin32KHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrGraphicsBindingOpenGLWin32KHR calloc() {
        return XrGraphicsBindingOpenGLWin32KHR.wrap(XrGraphicsBindingOpenGLWin32KHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrGraphicsBindingOpenGLWin32KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrGraphicsBindingOpenGLWin32KHR.wrap(XrGraphicsBindingOpenGLWin32KHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrGraphicsBindingOpenGLWin32KHR create(long address) {
        return XrGraphicsBindingOpenGLWin32KHR.wrap(XrGraphicsBindingOpenGLWin32KHR.class, address);
    }

    @Nullable
    public static XrGraphicsBindingOpenGLWin32KHR createSafe(long address) {
        return address == 0L ? null : XrGraphicsBindingOpenGLWin32KHR.wrap(XrGraphicsBindingOpenGLWin32KHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrGraphicsBindingOpenGLWin32KHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrGraphicsBindingOpenGLWin32KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrGraphicsBindingOpenGLWin32KHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsBindingOpenGLWin32KHR.__create(capacity, SIZEOF);
        return XrGraphicsBindingOpenGLWin32KHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrGraphicsBindingOpenGLWin32KHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrGraphicsBindingOpenGLWin32KHR.wrap(Buffer.class, address, capacity);
    }

    public static XrGraphicsBindingOpenGLWin32KHR malloc(MemoryStack stack) {
        return XrGraphicsBindingOpenGLWin32KHR.wrap(XrGraphicsBindingOpenGLWin32KHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGraphicsBindingOpenGLWin32KHR calloc(MemoryStack stack) {
        return XrGraphicsBindingOpenGLWin32KHR.wrap(XrGraphicsBindingOpenGLWin32KHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrGraphicsBindingOpenGLWin32KHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrGraphicsBindingOpenGLWin32KHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nhDC(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HDC);
    }

    public static long nhGLRC(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HGLRC);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nhDC(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HDC, Checks.check(value));
    }

    public static void nhGLRC(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HGLRC, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HDC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HGLRC));
    }

    static {
        Struct.Layout layout = XrGraphicsBindingOpenGLWin32KHR.__struct(XrGraphicsBindingOpenGLWin32KHR.__member(4), XrGraphicsBindingOpenGLWin32KHR.__member(POINTER_SIZE), XrGraphicsBindingOpenGLWin32KHR.__member(POINTER_SIZE), XrGraphicsBindingOpenGLWin32KHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        HDC = layout.offsetof(2);
        HGLRC = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsBindingOpenGLWin32KHR, Buffer>
    implements NativeResource {
        private static final XrGraphicsBindingOpenGLWin32KHR ELEMENT_FACTORY = XrGraphicsBindingOpenGLWin32KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrGraphicsBindingOpenGLWin32KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsBindingOpenGLWin32KHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGraphicsBindingOpenGLWin32KHR.nnext(this.address());
        }

        @NativeType(value="HDC")
        public long hDC() {
            return XrGraphicsBindingOpenGLWin32KHR.nhDC(this.address());
        }

        @NativeType(value="HGLRC")
        public long hGLRC() {
            return XrGraphicsBindingOpenGLWin32KHR.nhGLRC(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsBindingOpenGLWin32KHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000023000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGraphicsBindingOpenGLWin32KHR.nnext(this.address(), value);
            return this;
        }

        public Buffer hDC(@NativeType(value="HDC") long value) {
            XrGraphicsBindingOpenGLWin32KHR.nhDC(this.address(), value);
            return this;
        }

        public Buffer hGLRC(@NativeType(value="HGLRC") long value) {
            XrGraphicsBindingOpenGLWin32KHR.nhGLRC(this.address(), value);
            return this;
        }
    }
}

