/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrGraphicsBindingVulkanKHR;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class XrGraphicsBindingVulkan2KHR
extends XrGraphicsBindingVulkanKHR {
    public XrGraphicsBindingVulkan2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrGraphicsBindingVulkan2KHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsBindingVulkan2KHR.ntype(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR type$Default() {
        return this.type(1000025000);
    }

    @Override
    public XrGraphicsBindingVulkan2KHR next(@NativeType(value="void const *") long value) {
        XrGraphicsBindingVulkan2KHR.nnext(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR instance(VkInstance value) {
        XrGraphicsBindingVulkan2KHR.ninstance(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR physicalDevice(VkPhysicalDevice value) {
        XrGraphicsBindingVulkan2KHR.nphysicalDevice(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR device(VkDevice value) {
        XrGraphicsBindingVulkan2KHR.ndevice(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        XrGraphicsBindingVulkan2KHR.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR queueIndex(@NativeType(value="uint32_t") int value) {
        XrGraphicsBindingVulkan2KHR.nqueueIndex(this.address(), value);
        return this;
    }

    @Override
    public XrGraphicsBindingVulkan2KHR set(int type, long next, VkInstance instance, VkPhysicalDevice physicalDevice, VkDevice device, int queueFamilyIndex, int queueIndex) {
        this.type(type);
        this.next(next);
        this.instance(instance);
        this.physicalDevice(physicalDevice);
        this.device(device);
        this.queueFamilyIndex(queueFamilyIndex);
        this.queueIndex(queueIndex);
        return this;
    }

    public XrGraphicsBindingVulkan2KHR set(XrGraphicsBindingVulkan2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrGraphicsBindingVulkan2KHR malloc() {
        return XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrGraphicsBindingVulkan2KHR calloc() {
        return XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrGraphicsBindingVulkan2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrGraphicsBindingVulkan2KHR create(long address) {
        return XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, address);
    }

    @Nullable
    public static XrGraphicsBindingVulkan2KHR createSafe(long address) {
        return address == 0L ? null : XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrGraphicsBindingVulkan2KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsBindingVulkan2KHR.__create(capacity, SIZEOF);
        return XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, address, capacity);
    }

    public static XrGraphicsBindingVulkan2KHR malloc(MemoryStack stack) {
        return XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGraphicsBindingVulkan2KHR calloc(MemoryStack stack) {
        return XrGraphicsBindingVulkan2KHR.wrap(XrGraphicsBindingVulkan2KHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrGraphicsBindingVulkan2KHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrGraphicsBindingVulkanKHR.Buffer {
        private static final XrGraphicsBindingVulkan2KHR ELEMENT_FACTORY = XrGraphicsBindingVulkan2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrGraphicsBindingVulkan2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsBindingVulkan2KHR.ntype(this.address(), value);
            return this;
        }

        @Override
        public Buffer type$Default() {
            return this.type(1000025000);
        }

        @Override
        public Buffer next(@NativeType(value="void const *") long value) {
            XrGraphicsBindingVulkan2KHR.nnext(this.address(), value);
            return this;
        }

        @Override
        public Buffer instance(VkInstance value) {
            XrGraphicsBindingVulkan2KHR.ninstance(this.address(), value);
            return this;
        }

        @Override
        public Buffer physicalDevice(VkPhysicalDevice value) {
            XrGraphicsBindingVulkan2KHR.nphysicalDevice(this.address(), value);
            return this;
        }

        @Override
        public Buffer device(VkDevice value) {
            XrGraphicsBindingVulkan2KHR.ndevice(this.address(), value);
            return this;
        }

        @Override
        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            XrGraphicsBindingVulkan2KHR.nqueueFamilyIndex(this.address(), value);
            return this;
        }

        @Override
        public Buffer queueIndex(@NativeType(value="uint32_t") int value) {
            XrGraphicsBindingVulkan2KHR.nqueueIndex(this.address(), value);
            return this;
        }
    }
}

