/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGraphicsRequirementsOpenGLESKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MINAPIVERSIONSUPPORTED;
    public static final int MAXAPIVERSIONSUPPORTED;

    public XrGraphicsRequirementsOpenGLESKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrGraphicsRequirementsOpenGLESKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsRequirementsOpenGLESKHR.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrGraphicsRequirementsOpenGLESKHR.nnext(this.address());
    }

    @NativeType(value="XrVersion")
    public long minApiVersionSupported() {
        return XrGraphicsRequirementsOpenGLESKHR.nminApiVersionSupported(this.address());
    }

    @NativeType(value="XrVersion")
    public long maxApiVersionSupported() {
        return XrGraphicsRequirementsOpenGLESKHR.nmaxApiVersionSupported(this.address());
    }

    public XrGraphicsRequirementsOpenGLESKHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsRequirementsOpenGLESKHR.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsOpenGLESKHR type$Default() {
        return this.type(1000024003);
    }

    public XrGraphicsRequirementsOpenGLESKHR next(@NativeType(value="void *") long value) {
        XrGraphicsRequirementsOpenGLESKHR.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsOpenGLESKHR minApiVersionSupported(@NativeType(value="XrVersion") long value) {
        XrGraphicsRequirementsOpenGLESKHR.nminApiVersionSupported(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsOpenGLESKHR maxApiVersionSupported(@NativeType(value="XrVersion") long value) {
        XrGraphicsRequirementsOpenGLESKHR.nmaxApiVersionSupported(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsOpenGLESKHR set(int type, long next, long minApiVersionSupported, long maxApiVersionSupported) {
        this.type(type);
        this.next(next);
        this.minApiVersionSupported(minApiVersionSupported);
        this.maxApiVersionSupported(maxApiVersionSupported);
        return this;
    }

    public XrGraphicsRequirementsOpenGLESKHR set(XrGraphicsRequirementsOpenGLESKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrGraphicsRequirementsOpenGLESKHR malloc() {
        return XrGraphicsRequirementsOpenGLESKHR.wrap(XrGraphicsRequirementsOpenGLESKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrGraphicsRequirementsOpenGLESKHR calloc() {
        return XrGraphicsRequirementsOpenGLESKHR.wrap(XrGraphicsRequirementsOpenGLESKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrGraphicsRequirementsOpenGLESKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrGraphicsRequirementsOpenGLESKHR.wrap(XrGraphicsRequirementsOpenGLESKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrGraphicsRequirementsOpenGLESKHR create(long address) {
        return XrGraphicsRequirementsOpenGLESKHR.wrap(XrGraphicsRequirementsOpenGLESKHR.class, address);
    }

    @Nullable
    public static XrGraphicsRequirementsOpenGLESKHR createSafe(long address) {
        return address == 0L ? null : XrGraphicsRequirementsOpenGLESKHR.wrap(XrGraphicsRequirementsOpenGLESKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrGraphicsRequirementsOpenGLESKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrGraphicsRequirementsOpenGLESKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrGraphicsRequirementsOpenGLESKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsRequirementsOpenGLESKHR.__create(capacity, SIZEOF);
        return XrGraphicsRequirementsOpenGLESKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrGraphicsRequirementsOpenGLESKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrGraphicsRequirementsOpenGLESKHR.wrap(Buffer.class, address, capacity);
    }

    public static XrGraphicsRequirementsOpenGLESKHR malloc(MemoryStack stack) {
        return XrGraphicsRequirementsOpenGLESKHR.wrap(XrGraphicsRequirementsOpenGLESKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGraphicsRequirementsOpenGLESKHR calloc(MemoryStack stack) {
        return XrGraphicsRequirementsOpenGLESKHR.wrap(XrGraphicsRequirementsOpenGLESKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrGraphicsRequirementsOpenGLESKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrGraphicsRequirementsOpenGLESKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nminApiVersionSupported(long struct) {
        return UNSAFE.getLong(null, struct + (long)MINAPIVERSIONSUPPORTED);
    }

    public static long nmaxApiVersionSupported(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAXAPIVERSIONSUPPORTED);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nminApiVersionSupported(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MINAPIVERSIONSUPPORTED, value);
    }

    public static void nmaxApiVersionSupported(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MAXAPIVERSIONSUPPORTED, value);
    }

    static {
        Struct.Layout layout = XrGraphicsRequirementsOpenGLESKHR.__struct(XrGraphicsRequirementsOpenGLESKHR.__member(4), XrGraphicsRequirementsOpenGLESKHR.__member(POINTER_SIZE), XrGraphicsRequirementsOpenGLESKHR.__member(8), XrGraphicsRequirementsOpenGLESKHR.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MINAPIVERSIONSUPPORTED = layout.offsetof(2);
        MAXAPIVERSIONSUPPORTED = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsRequirementsOpenGLESKHR, Buffer>
    implements NativeResource {
        private static final XrGraphicsRequirementsOpenGLESKHR ELEMENT_FACTORY = XrGraphicsRequirementsOpenGLESKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrGraphicsRequirementsOpenGLESKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsRequirementsOpenGLESKHR.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrGraphicsRequirementsOpenGLESKHR.nnext(this.address());
        }

        @NativeType(value="XrVersion")
        public long minApiVersionSupported() {
            return XrGraphicsRequirementsOpenGLESKHR.nminApiVersionSupported(this.address());
        }

        @NativeType(value="XrVersion")
        public long maxApiVersionSupported() {
            return XrGraphicsRequirementsOpenGLESKHR.nmaxApiVersionSupported(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsRequirementsOpenGLESKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000024003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrGraphicsRequirementsOpenGLESKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer minApiVersionSupported(@NativeType(value="XrVersion") long value) {
            XrGraphicsRequirementsOpenGLESKHR.nminApiVersionSupported(this.address(), value);
            return this;
        }

        public Buffer maxApiVersionSupported(@NativeType(value="XrVersion") long value) {
            XrGraphicsRequirementsOpenGLESKHR.nmaxApiVersionSupported(this.address(), value);
            return this;
        }
    }
}

