/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandMeshIndexBufferMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INDEXBUFFERKEY;
    public static final int INDEXCAPACITYINPUT;
    public static final int INDEXCOUNTOUTPUT;
    public static final int INDICES;

    public XrHandMeshIndexBufferMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandMeshIndexBufferMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int indexBufferKey() {
        return XrHandMeshIndexBufferMSFT.nindexBufferKey(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCapacityInput() {
        return XrHandMeshIndexBufferMSFT.nindexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCountOutput() {
        return XrHandMeshIndexBufferMSFT.nindexCountOutput(this.address());
    }

    @NativeType(value="uint32_t *")
    public IntBuffer indices() {
        return XrHandMeshIndexBufferMSFT.nindices(this.address());
    }

    public XrHandMeshIndexBufferMSFT indexBufferKey(@NativeType(value="uint32_t") int value) {
        XrHandMeshIndexBufferMSFT.nindexBufferKey(this.address(), value);
        return this;
    }

    public XrHandMeshIndexBufferMSFT indexCountOutput(@NativeType(value="uint32_t") int value) {
        XrHandMeshIndexBufferMSFT.nindexCountOutput(this.address(), value);
        return this;
    }

    public XrHandMeshIndexBufferMSFT indices(@NativeType(value="uint32_t *") IntBuffer value) {
        XrHandMeshIndexBufferMSFT.nindices(this.address(), value);
        return this;
    }

    public XrHandMeshIndexBufferMSFT set(int indexBufferKey, int indexCountOutput, IntBuffer indices) {
        this.indexBufferKey(indexBufferKey);
        this.indexCountOutput(indexCountOutput);
        this.indices(indices);
        return this;
    }

    public XrHandMeshIndexBufferMSFT set(XrHandMeshIndexBufferMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandMeshIndexBufferMSFT malloc() {
        return XrHandMeshIndexBufferMSFT.wrap(XrHandMeshIndexBufferMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHandMeshIndexBufferMSFT calloc() {
        return XrHandMeshIndexBufferMSFT.wrap(XrHandMeshIndexBufferMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHandMeshIndexBufferMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHandMeshIndexBufferMSFT.wrap(XrHandMeshIndexBufferMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHandMeshIndexBufferMSFT create(long address) {
        return XrHandMeshIndexBufferMSFT.wrap(XrHandMeshIndexBufferMSFT.class, address);
    }

    @Nullable
    public static XrHandMeshIndexBufferMSFT createSafe(long address) {
        return address == 0L ? null : XrHandMeshIndexBufferMSFT.wrap(XrHandMeshIndexBufferMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrHandMeshIndexBufferMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHandMeshIndexBufferMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHandMeshIndexBufferMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandMeshIndexBufferMSFT.__create(capacity, SIZEOF);
        return XrHandMeshIndexBufferMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHandMeshIndexBufferMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHandMeshIndexBufferMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrHandMeshIndexBufferMSFT malloc(MemoryStack stack) {
        return XrHandMeshIndexBufferMSFT.wrap(XrHandMeshIndexBufferMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandMeshIndexBufferMSFT calloc(MemoryStack stack) {
        return XrHandMeshIndexBufferMSFT.wrap(XrHandMeshIndexBufferMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHandMeshIndexBufferMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHandMeshIndexBufferMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nindexBufferKey(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXBUFFERKEY);
    }

    public static int nindexCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXCAPACITYINPUT);
    }

    public static int nindexCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXCOUNTOUTPUT);
    }

    public static IntBuffer nindices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)INDICES), XrHandMeshIndexBufferMSFT.nindexCapacityInput(struct));
    }

    public static void nindexBufferKey(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXBUFFERKEY, value);
    }

    public static void nindexCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXCAPACITYINPUT, value);
    }

    public static void nindexCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXCOUNTOUTPUT, value);
    }

    public static void nindices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INDICES, MemoryUtil.memAddress(value));
        XrHandMeshIndexBufferMSFT.nindexCapacityInput(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INDICES));
    }

    static {
        Struct.Layout layout = XrHandMeshIndexBufferMSFT.__struct(XrHandMeshIndexBufferMSFT.__member(4), XrHandMeshIndexBufferMSFT.__member(4), XrHandMeshIndexBufferMSFT.__member(4), XrHandMeshIndexBufferMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INDEXBUFFERKEY = layout.offsetof(0);
        INDEXCAPACITYINPUT = layout.offsetof(1);
        INDEXCOUNTOUTPUT = layout.offsetof(2);
        INDICES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandMeshIndexBufferMSFT, Buffer>
    implements NativeResource {
        private static final XrHandMeshIndexBufferMSFT ELEMENT_FACTORY = XrHandMeshIndexBufferMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHandMeshIndexBufferMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int indexBufferKey() {
            return XrHandMeshIndexBufferMSFT.nindexBufferKey(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCapacityInput() {
            return XrHandMeshIndexBufferMSFT.nindexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCountOutput() {
            return XrHandMeshIndexBufferMSFT.nindexCountOutput(this.address());
        }

        @NativeType(value="uint32_t *")
        public IntBuffer indices() {
            return XrHandMeshIndexBufferMSFT.nindices(this.address());
        }

        public Buffer indexBufferKey(@NativeType(value="uint32_t") int value) {
            XrHandMeshIndexBufferMSFT.nindexBufferKey(this.address(), value);
            return this;
        }

        public Buffer indexCountOutput(@NativeType(value="uint32_t") int value) {
            XrHandMeshIndexBufferMSFT.nindexCountOutput(this.address(), value);
            return this;
        }

        public Buffer indices(@NativeType(value="uint32_t *") IntBuffer value) {
            XrHandMeshIndexBufferMSFT.nindices(this.address(), value);
            return this;
        }
    }
}

